/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Announcement banner configuration.")
public class AnnouncementBannerConfiguration {
    @JsonProperty(value="hashId")
    private String hashId;
    @JsonProperty(value="isDismissible")
    private Boolean isDismissible;
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="visibility")
    private VisibilityEnum visibility;

    @ApiModelProperty(value="Hash of the banner data. The client detects updates by comparing hash IDs.")
    public String getHashId() {
        return this.hashId;
    }

    @ApiModelProperty(value="Flag indicating if the announcement banner can be dismissed by the user.")
    public Boolean getIsDismissible() {
        return this.isDismissible;
    }

    @ApiModelProperty(value="Flag indicating if the announcement banner is enabled or not.")
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    @ApiModelProperty(value="The text on the announcement banner.")
    public String getMessage() {
        return this.message;
    }

    @ApiModelProperty(value="Visibility of the announcement banner.")
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnouncementBannerConfiguration announcementBannerConfiguration = (AnnouncementBannerConfiguration)o;
        return Objects.equals(this.hashId, announcementBannerConfiguration.hashId) && Objects.equals(this.isDismissible, announcementBannerConfiguration.isDismissible) && Objects.equals(this.isEnabled, announcementBannerConfiguration.isEnabled) && Objects.equals(this.message, announcementBannerConfiguration.message) && Objects.equals((Object)this.visibility, (Object)announcementBannerConfiguration.visibility);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hashId, this.isDismissible, this.isEnabled, this.message, this.visibility});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnnouncementBannerConfiguration {\n");
        sb.append("    hashId: ").append(this.toIndentedString(this.hashId)).append("\n");
        sb.append("    isDismissible: ").append(this.toIndentedString(this.isDismissible)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum VisibilityEnum {
        PUBLIC("PUBLIC"),
        PRIVATE("PRIVATE");

        private String value;

        private VisibilityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VisibilityEnum fromValue(String value) {
            for (VisibilityEnum b : VisibilityEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

