/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanWorkflowTransitionRules;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowTransitionRulesUpdate;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowTransitionRulesUpdateErrors;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowsWithTransitionRulesDetails;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class WorkflowTransitionRulesApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<WorkflowTransitionRulesUpdateErrors> returnType_deleteWorkflowTransitionRuleConfigurations = new TypeReference<WorkflowTransitionRulesUpdateErrors>(){};
    private static final TypeReference<PageBeanWorkflowTransitionRules> returnType_getWorkflowTransitionRuleConfigurations = new TypeReference<PageBeanWorkflowTransitionRules>(){};
    private static final TypeReference<WorkflowTransitionRulesUpdateErrors> returnType_updateWorkflowTransitionRuleConfigurations = new TypeReference<WorkflowTransitionRulesUpdateErrors>(){};
    private final RestClient restClient;

    public WorkflowTransitionRulesApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<WorkflowTransitionRulesUpdateErrors> deleteWorkflowTransitionRuleConfigurations(WorkflowsWithTransitionRulesDetails workflowsWithTransitionRulesDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflow/rule/config/delete");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(workflowsWithTransitionRulesDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteWorkflowTransitionRuleConfigurations);
    }

    public Single<PageBeanWorkflowTransitionRules> getWorkflowTransitionRuleConfigurations(List<String> types, Optional<Long> startAt, Optional<Integer> maxResults, Optional<List<String>> keys, Optional<List<String>> workflowNames, Optional<List<String>> withTags, Optional<Boolean> draft, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflow/rule/config");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        queryParams.put("types", RestClientUtil.objectCollectionToStringCollection(types));
        if (keys.isPresent()) {
            queryParams.put("keys", RestClientUtil.objectCollectionToStringCollection((Collection)keys.get()));
        }
        if (workflowNames.isPresent()) {
            queryParams.put("workflowNames", RestClientUtil.objectCollectionToStringCollection((Collection)workflowNames.get()));
        }
        if (withTags.isPresent()) {
            queryParams.put("withTags", RestClientUtil.objectCollectionToStringCollection((Collection)withTags.get()));
        }
        if (draft.isPresent()) {
            queryParams.put("draft", Collections.singleton(String.valueOf(draft.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getWorkflowTransitionRuleConfigurations);
    }

    public Single<WorkflowTransitionRulesUpdateErrors> updateWorkflowTransitionRuleConfigurations(WorkflowTransitionRulesUpdate workflowTransitionRulesUpdate, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflow/rule/config");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(workflowTransitionRulesUpdate));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateWorkflowTransitionRuleConfigurations);
    }
}

