/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Single;
import java.util.HashMap;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v3.model.TaskProgressBeanObject;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class TasksApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<Object> returnType_cancelTask = new TypeReference<Object>(){};
    private static final TypeReference<TaskProgressBeanObject> returnType_getTask = new TypeReference<TaskProgressBeanObject>(){};
    private final RestClient restClient;

    public TasksApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> cancelTask(String taskId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/task/{taskId}/cancel");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("taskId", String.valueOf(taskId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_cancelTask);
    }

    public Single<TaskProgressBeanObject> getTask(String taskId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/task/{taskId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("taskId", String.valueOf(taskId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getTask);
    }
}

