/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Single;
import java.util.HashMap;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v3.model.ContainerForProjectFeatures;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectFeatureState;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ProjectFeaturesApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<ContainerForProjectFeatures> returnType_getFeaturesForProject = new TypeReference<ContainerForProjectFeatures>(){};
    private static final TypeReference<ContainerForProjectFeatures> returnType_toggleFeatureForProject = new TypeReference<ContainerForProjectFeatures>(){};
    private final RestClient restClient;

    public ProjectFeaturesApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<ContainerForProjectFeatures> getFeaturesForProject(String projectIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/features");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getFeaturesForProject);
    }

    public Single<ContainerForProjectFeatures> toggleFeatureForProject(String projectIdOrKey, String featureKey, ProjectFeatureState projectFeatureState, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/features/{featureKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        pathParams.put("featureKey", String.valueOf(featureKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(projectFeatureState));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_toggleFeatureForProject);
    }
}

