/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.Avatar;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectAvatars;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ProjectAvatarsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<Avatar> returnType_createProjectAvatar = new TypeReference<Avatar>(){};
    private static final TypeReference<ProjectAvatars> returnType_getAllProjectAvatars = new TypeReference<ProjectAvatars>(){};
    private static final TypeReference<Object> returnType_updateProjectAvatar = new TypeReference<Object>(){};
    private final RestClient restClient;

    public ProjectAvatarsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Avatar> createProjectAvatar(String projectIdOrKey, Object body, Optional<Integer> x, Optional<Integer> y, Optional<Integer> size, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/avatar2");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (x.isPresent()) {
            queryParams.put("x", Collections.singleton(String.valueOf(x.get())));
        }
        if (y.isPresent()) {
            queryParams.put("y", Collections.singleton(String.valueOf(y.get())));
        }
        if (size.isPresent()) {
            queryParams.put("size", Collections.singleton(String.valueOf(size.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(body));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createProjectAvatar);
    }

    public Completable deleteProjectAvatar(String projectIdOrKey, Long id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/avatar/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<ProjectAvatars> getAllProjectAvatars(String projectIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/avatars");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllProjectAvatars);
    }

    public Single<Object> updateProjectAvatar(String projectIdOrKey, Map<String, Object> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/avatar");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateProjectAvatar);
    }
}

