/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.NotificationScheme;
import org.everit.atlassian.restclient.jiracloud.v3.model.NotificationSchemeId;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanNotificationScheme;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanNotificationSchemeAndProjectMappingJsonBean;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueNotificationSchemesApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<Object> returnType_addNotifications = new TypeReference<Object>(){};
    private static final TypeReference<NotificationSchemeId> returnType_createNotificationScheme = new TypeReference<NotificationSchemeId>(){};
    private static final TypeReference<Object> returnType_deleteNotificationScheme = new TypeReference<Object>(){};
    private static final TypeReference<NotificationScheme> returnType_getNotificationScheme = new TypeReference<NotificationScheme>(){};
    private static final TypeReference<PageBeanNotificationSchemeAndProjectMappingJsonBean> returnType_getNotificationSchemeToProjectMappings = new TypeReference<PageBeanNotificationSchemeAndProjectMappingJsonBean>(){};
    private static final TypeReference<PageBeanNotificationScheme> returnType_getNotificationSchemes = new TypeReference<PageBeanNotificationScheme>(){};
    private static final TypeReference<Object> returnType_removeNotificationFromNotificationScheme = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_updateNotificationScheme = new TypeReference<Object>(){};
    private final RestClient restClient;

    public IssueNotificationSchemesApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> addNotifications(String id, Map<String, Object> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/notificationscheme/{id}/notification");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addNotifications);
    }

    public Single<NotificationSchemeId> createNotificationScheme(Map<String, Object> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/notificationscheme");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createNotificationScheme);
    }

    public Single<Object> deleteNotificationScheme(String notificationSchemeId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/notificationscheme/{notificationSchemeId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("notificationSchemeId", String.valueOf(notificationSchemeId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteNotificationScheme);
    }

    public Single<NotificationScheme> getNotificationScheme(Long id, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/notificationscheme/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getNotificationScheme);
    }

    public Single<PageBeanNotificationSchemeAndProjectMappingJsonBean> getNotificationSchemeToProjectMappings(Optional<String> startAt, Optional<String> maxResults, Optional<List<String>> notificationSchemeId, Optional<List<String>> projectId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/notificationscheme/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (notificationSchemeId.isPresent()) {
            queryParams.put("notificationSchemeId", RestClientUtil.objectCollectionToStringCollection((Collection)notificationSchemeId.get()));
        }
        if (projectId.isPresent()) {
            queryParams.put("projectId", RestClientUtil.objectCollectionToStringCollection((Collection)projectId.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getNotificationSchemeToProjectMappings);
    }

    public Single<PageBeanNotificationScheme> getNotificationSchemes(Optional<String> startAt, Optional<String> maxResults, Optional<List<String>> id, Optional<List<String>> projectId, Optional<Boolean> onlyDefault, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/notificationscheme");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        if (projectId.isPresent()) {
            queryParams.put("projectId", RestClientUtil.objectCollectionToStringCollection((Collection)projectId.get()));
        }
        if (onlyDefault.isPresent()) {
            queryParams.put("onlyDefault", Collections.singleton(String.valueOf(onlyDefault.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getNotificationSchemes);
    }

    public Single<Object> removeNotificationFromNotificationScheme(String notificationSchemeId, String notificationId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/notificationscheme/{notificationSchemeId}/notification/{notificationId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("notificationSchemeId", String.valueOf(notificationSchemeId));
        pathParams.put("notificationId", String.valueOf(notificationId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_removeNotificationFromNotificationScheme);
    }

    public Single<Object> updateNotificationScheme(String id, Map<String, Object> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/notificationscheme/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateNotificationScheme);
    }
}

