/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.DocumentVersion;
import org.everit.atlassian.restclient.jiracloud.v2.model.StatusLayoutUpdate;
import org.everit.atlassian.restclient.jiracloud.v2.model.StatusMappingDTO;
import org.everit.atlassian.restclient.jiracloud.v2.model.StatusMigration;
import org.everit.atlassian.restclient.jiracloud.v2.model.TransitionUpdateDTO;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowLayout;

@ApiModel(description="The details of the workflows to update.")
public class WorkflowUpdate {
    @JsonProperty(value="defaultStatusMappings")
    private List<StatusMigration> defaultStatusMappings = new ArrayList<StatusMigration>();
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="startPointLayout")
    private WorkflowLayout startPointLayout;
    @JsonProperty(value="statusMappings")
    private List<StatusMappingDTO> statusMappings = new ArrayList<StatusMappingDTO>();
    @JsonProperty(value="statuses")
    private List<StatusLayoutUpdate> statuses = new ArrayList<StatusLayoutUpdate>();
    @JsonProperty(value="transitions")
    private List<TransitionUpdateDTO> transitions = new ArrayList<TransitionUpdateDTO>();
    @JsonProperty(value="version")
    private DocumentVersion version;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public WorkflowUpdate defaultStatusMappings(List<StatusMigration> defaultStatusMappings) {
        this.defaultStatusMappings = defaultStatusMappings;
        return this;
    }

    public WorkflowUpdate addDefaultStatusMappingsItem(StatusMigration defaultStatusMappingsItem) {
        if (this.defaultStatusMappings == null) {
            this.defaultStatusMappings = new ArrayList<StatusMigration>();
        }
        this.defaultStatusMappings.add(defaultStatusMappingsItem);
        return this;
    }

    @ApiModelProperty(value="The mapping of old to new status ID.")
    public List<StatusMigration> getDefaultStatusMappings() {
        return this.defaultStatusMappings;
    }

    public void setDefaultStatusMappings(List<StatusMigration> defaultStatusMappings) {
        this.defaultStatusMappings = defaultStatusMappings;
    }

    public WorkflowUpdate description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The new description for this workflow.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkflowUpdate id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of this workflow.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkflowUpdate startPointLayout(WorkflowLayout startPointLayout) {
        this.startPointLayout = startPointLayout;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowLayout getStartPointLayout() {
        return this.startPointLayout;
    }

    public void setStartPointLayout(WorkflowLayout startPointLayout) {
        this.startPointLayout = startPointLayout;
    }

    public WorkflowUpdate statusMappings(List<StatusMappingDTO> statusMappings) {
        this.statusMappings = statusMappings;
        return this;
    }

    public WorkflowUpdate addStatusMappingsItem(StatusMappingDTO statusMappingsItem) {
        if (this.statusMappings == null) {
            this.statusMappings = new ArrayList<StatusMappingDTO>();
        }
        this.statusMappings.add(statusMappingsItem);
        return this;
    }

    @ApiModelProperty(value="The mapping of old to new status ID for a specific project and issue type.")
    public List<StatusMappingDTO> getStatusMappings() {
        return this.statusMappings;
    }

    public void setStatusMappings(List<StatusMappingDTO> statusMappings) {
        this.statusMappings = statusMappings;
    }

    public WorkflowUpdate statuses(List<StatusLayoutUpdate> statuses) {
        this.statuses = statuses;
        return this;
    }

    public WorkflowUpdate addStatusesItem(StatusLayoutUpdate statusesItem) {
        this.statuses.add(statusesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The statuses associated with this workflow.")
    public List<StatusLayoutUpdate> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<StatusLayoutUpdate> statuses) {
        this.statuses = statuses;
    }

    public WorkflowUpdate transitions(List<TransitionUpdateDTO> transitions) {
        this.transitions = transitions;
        return this;
    }

    public WorkflowUpdate addTransitionsItem(TransitionUpdateDTO transitionsItem) {
        this.transitions.add(transitionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The transitions of this workflow.")
    public List<TransitionUpdateDTO> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(List<TransitionUpdateDTO> transitions) {
        this.transitions = transitions;
    }

    public WorkflowUpdate version(DocumentVersion version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DocumentVersion getVersion() {
        return this.version;
    }

    public void setVersion(DocumentVersion version) {
        this.version = version;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowUpdate workflowUpdate = (WorkflowUpdate)o;
        return Objects.equals(this.defaultStatusMappings, workflowUpdate.defaultStatusMappings) && Objects.equals(this.description, workflowUpdate.description) && Objects.equals(this.id, workflowUpdate.id) && Objects.equals(this.startPointLayout, workflowUpdate.startPointLayout) && Objects.equals(this.statusMappings, workflowUpdate.statusMappings) && Objects.equals(this.statuses, workflowUpdate.statuses) && Objects.equals(this.transitions, workflowUpdate.transitions) && Objects.equals(this.version, workflowUpdate.version) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.defaultStatusMappings, this.description, this.id, this.startPointLayout, this.statusMappings, this.statuses, this.transitions, this.version, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowUpdate {\n");
        sb.append("    defaultStatusMappings: ").append(this.toIndentedString(this.defaultStatusMappings)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    startPointLayout: ").append(this.toIndentedString(this.startPointLayout)).append("\n");
        sb.append("    statusMappings: ").append(this.toIndentedString(this.statusMappings)).append("\n");
        sb.append("    statuses: ").append(this.toIndentedString(this.statuses)).append("\n");
        sb.append("    transitions: ").append(this.toIndentedString(this.transitions)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

