/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="The trigger configuration associated with a workflow.")
public class WorkflowTrigger {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="parameters")
    private Map<String, String> parameters = new HashMap<String, String>();
    @JsonProperty(value="ruleKey")
    private String ruleKey;

    public WorkflowTrigger id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the trigger.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkflowTrigger parameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public WorkflowTrigger putParametersItem(String key, String parametersItem) {
        this.parameters.put(key, parametersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The parameters of the trigger.")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public WorkflowTrigger ruleKey(String ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @ApiModelProperty(required=true, value="The rule key of the trigger.")
    public String getRuleKey() {
        return this.ruleKey;
    }

    public void setRuleKey(String ruleKey) {
        this.ruleKey = ruleKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowTrigger workflowTrigger = (WorkflowTrigger)o;
        return Objects.equals(this.id, workflowTrigger.id) && Objects.equals(this.parameters, workflowTrigger.parameters) && Objects.equals(this.ruleKey, workflowTrigger.ruleKey);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parameters, this.ruleKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowTrigger {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    ruleKey: ").append(this.toIndentedString(this.ruleKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

