/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.ConditionGroupConfiguration;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowRuleConfiguration;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowStatusAndPort;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowTrigger;

@ApiModel(description="The transitions of the workflow.")
public class WorkflowTransitions {
    @JsonProperty(value="actions")
    private List<WorkflowRuleConfiguration> actions = new ArrayList<WorkflowRuleConfiguration>();
    @JsonProperty(value="conditions")
    private ConditionGroupConfiguration conditions;
    @JsonProperty(value="customIssueEventId")
    private String customIssueEventId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="from")
    private List<WorkflowStatusAndPort> from = new ArrayList<WorkflowStatusAndPort>();
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="properties")
    private Map<String, String> properties = new HashMap<String, String>();
    @JsonProperty(value="to")
    private WorkflowStatusAndPort to;
    @JsonProperty(value="transitionScreen")
    private WorkflowRuleConfiguration transitionScreen;
    @JsonProperty(value="triggers")
    private List<WorkflowTrigger> triggers = new ArrayList<WorkflowTrigger>();
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="validators")
    private List<WorkflowRuleConfiguration> validators = new ArrayList<WorkflowRuleConfiguration>();

    public WorkflowTransitions actions(List<WorkflowRuleConfiguration> actions) {
        this.actions = actions;
        return this;
    }

    public WorkflowTransitions addActionsItem(WorkflowRuleConfiguration actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<WorkflowRuleConfiguration>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @ApiModelProperty(value="The post-functions of the transition.")
    public List<WorkflowRuleConfiguration> getActions() {
        return this.actions;
    }

    public void setActions(List<WorkflowRuleConfiguration> actions) {
        this.actions = actions;
    }

    public WorkflowTransitions conditions(ConditionGroupConfiguration conditions) {
        this.conditions = conditions;
        return this;
    }

    @ApiModelProperty(value="")
    public ConditionGroupConfiguration getConditions() {
        return this.conditions;
    }

    public void setConditions(ConditionGroupConfiguration conditions) {
        this.conditions = conditions;
    }

    public WorkflowTransitions customIssueEventId(String customIssueEventId) {
        this.customIssueEventId = customIssueEventId;
        return this;
    }

    @ApiModelProperty(value="The custom event ID of the transition.")
    public String getCustomIssueEventId() {
        return this.customIssueEventId;
    }

    public void setCustomIssueEventId(String customIssueEventId) {
        this.customIssueEventId = customIssueEventId;
    }

    public WorkflowTransitions description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the transition.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkflowTransitions from(List<WorkflowStatusAndPort> from) {
        this.from = from;
        return this;
    }

    public WorkflowTransitions addFromItem(WorkflowStatusAndPort fromItem) {
        if (this.from == null) {
            this.from = new ArrayList<WorkflowStatusAndPort>();
        }
        this.from.add(fromItem);
        return this;
    }

    @ApiModelProperty(value="The statuses the transition can start from.")
    public List<WorkflowStatusAndPort> getFrom() {
        return this.from;
    }

    public void setFrom(List<WorkflowStatusAndPort> from) {
        this.from = from;
    }

    public WorkflowTransitions id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the transition.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkflowTransitions name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the transition.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkflowTransitions properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public WorkflowTransitions putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="The properties of the transition.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public WorkflowTransitions to(WorkflowStatusAndPort to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowStatusAndPort getTo() {
        return this.to;
    }

    public void setTo(WorkflowStatusAndPort to) {
        this.to = to;
    }

    public WorkflowTransitions transitionScreen(WorkflowRuleConfiguration transitionScreen) {
        this.transitionScreen = transitionScreen;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowRuleConfiguration getTransitionScreen() {
        return this.transitionScreen;
    }

    public void setTransitionScreen(WorkflowRuleConfiguration transitionScreen) {
        this.transitionScreen = transitionScreen;
    }

    public WorkflowTransitions triggers(List<WorkflowTrigger> triggers) {
        this.triggers = triggers;
        return this;
    }

    public WorkflowTransitions addTriggersItem(WorkflowTrigger triggersItem) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<WorkflowTrigger>();
        }
        this.triggers.add(triggersItem);
        return this;
    }

    @ApiModelProperty(value="The triggers of the transition.")
    public List<WorkflowTrigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<WorkflowTrigger> triggers) {
        this.triggers = triggers;
    }

    public WorkflowTransitions type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The transition type.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public WorkflowTransitions validators(List<WorkflowRuleConfiguration> validators) {
        this.validators = validators;
        return this;
    }

    public WorkflowTransitions addValidatorsItem(WorkflowRuleConfiguration validatorsItem) {
        if (this.validators == null) {
            this.validators = new ArrayList<WorkflowRuleConfiguration>();
        }
        this.validators.add(validatorsItem);
        return this;
    }

    @ApiModelProperty(value="The validators of the transition.")
    public List<WorkflowRuleConfiguration> getValidators() {
        return this.validators;
    }

    public void setValidators(List<WorkflowRuleConfiguration> validators) {
        this.validators = validators;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowTransitions workflowTransitions = (WorkflowTransitions)o;
        return Objects.equals(this.actions, workflowTransitions.actions) && Objects.equals(this.conditions, workflowTransitions.conditions) && Objects.equals(this.customIssueEventId, workflowTransitions.customIssueEventId) && Objects.equals(this.description, workflowTransitions.description) && Objects.equals(this.from, workflowTransitions.from) && Objects.equals(this.id, workflowTransitions.id) && Objects.equals(this.name, workflowTransitions.name) && Objects.equals(this.properties, workflowTransitions.properties) && Objects.equals(this.to, workflowTransitions.to) && Objects.equals(this.transitionScreen, workflowTransitions.transitionScreen) && Objects.equals(this.triggers, workflowTransitions.triggers) && Objects.equals((Object)this.type, (Object)workflowTransitions.type) && Objects.equals(this.validators, workflowTransitions.validators);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actions, this.conditions, this.customIssueEventId, this.description, this.from, this.id, this.name, this.properties, this.to, this.transitionScreen, this.triggers, this.type, this.validators});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowTransitions {\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    customIssueEventId: ").append(this.toIndentedString(this.customIssueEventId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    transitionScreen: ").append(this.toIndentedString(this.transitionScreen)).append("\n");
        sb.append("    triggers: ").append(this.toIndentedString(this.triggers)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    validators: ").append(this.toIndentedString(this.validators)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        INITIAL("INITIAL"),
        GLOBAL("GLOBAL"),
        DIRECTED("DIRECTED");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

