/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectId;

@ApiModel(description="The scope of the workflow.")
public class WorkflowScope {
    @JsonProperty(value="project")
    private ProjectId project;
    @JsonProperty(value="type")
    private TypeEnum type;

    public WorkflowScope project(ProjectId project) {
        this.project = project;
        return this;
    }

    @ApiModelProperty(value="")
    public ProjectId getProject() {
        return this.project;
    }

    public void setProject(ProjectId project) {
        this.project = project;
    }

    public WorkflowScope type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The scope of the workflow. `GLOBAL` for company-managed projects and `PROJECT` for team-managed projects.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowScope workflowScope = (WorkflowScope)o;
        return Objects.equals(this.project, workflowScope.project) && Objects.equals((Object)this.type, (Object)workflowScope.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.project, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowScope {\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        PROJECT("PROJECT"),
        GLOBAL("GLOBAL");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

