/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@ApiModel(description="Details of the workflow and its transition rules.")
public class WorkflowRulesSearch {
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="ruleIds")
    private List<UUID> ruleIds = new ArrayList<UUID>();
    @JsonProperty(value="workflowEntityId")
    private UUID workflowEntityId;

    public WorkflowRulesSearch expand(String expand) {
        this.expand = expand;
        return this;
    }

    @ApiModelProperty(example="transition", value="Use expand to include additional information in the response. This parameter accepts `transition` which, for each rule, returns information about the transition the rule is assigned to.")
    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public WorkflowRulesSearch ruleIds(List<UUID> ruleIds) {
        this.ruleIds = ruleIds;
        return this;
    }

    public WorkflowRulesSearch addRuleIdsItem(UUID ruleIdsItem) {
        this.ruleIds.add(ruleIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of workflow rule IDs.")
    public List<UUID> getRuleIds() {
        return this.ruleIds;
    }

    public void setRuleIds(List<UUID> ruleIds) {
        this.ruleIds = ruleIds;
    }

    public WorkflowRulesSearch workflowEntityId(UUID workflowEntityId) {
        this.workflowEntityId = workflowEntityId;
        return this;
    }

    @ApiModelProperty(example="a498d711-685d-428d-8c3e-bc03bb450ea7", required=true, value="The workflow ID.")
    public UUID getWorkflowEntityId() {
        return this.workflowEntityId;
    }

    public void setWorkflowEntityId(UUID workflowEntityId) {
        this.workflowEntityId = workflowEntityId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowRulesSearch workflowRulesSearch = (WorkflowRulesSearch)o;
        return Objects.equals(this.expand, workflowRulesSearch.expand) && Objects.equals(this.ruleIds, workflowRulesSearch.ruleIds) && Objects.equals(this.workflowEntityId, workflowRulesSearch.workflowEntityId);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.ruleIds, this.workflowEntityId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowRulesSearch {\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    ruleIds: ").append(this.toIndentedString(this.ruleIds)).append("\n");
        sb.append("    workflowEntityId: ").append(this.toIndentedString(this.workflowEntityId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

