/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="The configuration of the rule.")
public class WorkflowRuleConfiguration {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="parameters")
    private Map<String, String> parameters = new HashMap<String, String>();
    @JsonProperty(value="ruleKey")
    private String ruleKey;

    public WorkflowRuleConfiguration id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the rule.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkflowRuleConfiguration parameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public WorkflowRuleConfiguration putParametersItem(String key, String parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @ApiModelProperty(value="The parameters related to the rule.")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public WorkflowRuleConfiguration ruleKey(String ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @ApiModelProperty(required=true, value="The rule key of the rule.")
    public String getRuleKey() {
        return this.ruleKey;
    }

    public void setRuleKey(String ruleKey) {
        this.ruleKey = ruleKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowRuleConfiguration workflowRuleConfiguration = (WorkflowRuleConfiguration)o;
        return Objects.equals(this.id, workflowRuleConfiguration.id) && Objects.equals(this.parameters, workflowRuleConfiguration.parameters) && Objects.equals(this.ruleKey, workflowRuleConfiguration.ruleKey);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parameters, this.ruleKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowRuleConfiguration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    ruleKey: ").append(this.toIndentedString(this.ruleKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

