/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.DocumentVersion;
import org.everit.atlassian.restclient.jiracloud.v2.model.SimpleUsage;

@ApiModel(description="Workflow metadata and usage detail.")
public class WorkflowMetadataRestModel {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="usage")
    private List<SimpleUsage> usage = new ArrayList<SimpleUsage>();
    @JsonProperty(value="version")
    private DocumentVersion version;

    public WorkflowMetadataRestModel description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the workflow.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkflowMetadataRestModel id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the workflow.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkflowMetadataRestModel name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the workflow.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkflowMetadataRestModel usage(List<SimpleUsage> usage) {
        this.usage = usage;
        return this;
    }

    public WorkflowMetadataRestModel addUsageItem(SimpleUsage usageItem) {
        this.usage.add(usageItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Use the optional `workflows.usages` expand to get additional information about the projects and issue types associated with the workflows in the workflow scheme.")
    public List<SimpleUsage> getUsage() {
        return this.usage;
    }

    public void setUsage(List<SimpleUsage> usage) {
        this.usage = usage;
    }

    public WorkflowMetadataRestModel version(DocumentVersion version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DocumentVersion getVersion() {
        return this.version;
    }

    public void setVersion(DocumentVersion version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowMetadataRestModel workflowMetadataRestModel = (WorkflowMetadataRestModel)o;
        return Objects.equals(this.description, workflowMetadataRestModel.description) && Objects.equals(this.id, workflowMetadataRestModel.id) && Objects.equals(this.name, workflowMetadataRestModel.name) && Objects.equals(this.usage, workflowMetadataRestModel.usage) && Objects.equals(this.version, workflowMetadataRestModel.version);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.id, this.name, this.usage, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowMetadataRestModel {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

