/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.StatusLayoutUpdate;
import org.everit.atlassian.restclient.jiracloud.v2.model.TransitionUpdateDTO;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowLayout;

@ApiModel(description="The details of the workflows to create.")
public class WorkflowCreate {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="startPointLayout")
    private WorkflowLayout startPointLayout;
    @JsonProperty(value="statuses")
    private List<StatusLayoutUpdate> statuses = new ArrayList<StatusLayoutUpdate>();
    @JsonProperty(value="transitions")
    private List<TransitionUpdateDTO> transitions = new ArrayList<TransitionUpdateDTO>();

    public WorkflowCreate description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the workflow to create.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkflowCreate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the workflow to create.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkflowCreate startPointLayout(WorkflowLayout startPointLayout) {
        this.startPointLayout = startPointLayout;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowLayout getStartPointLayout() {
        return this.startPointLayout;
    }

    public void setStartPointLayout(WorkflowLayout startPointLayout) {
        this.startPointLayout = startPointLayout;
    }

    public WorkflowCreate statuses(List<StatusLayoutUpdate> statuses) {
        this.statuses = statuses;
        return this;
    }

    public WorkflowCreate addStatusesItem(StatusLayoutUpdate statusesItem) {
        this.statuses.add(statusesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The statuses associated with this workflow.")
    public List<StatusLayoutUpdate> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<StatusLayoutUpdate> statuses) {
        this.statuses = statuses;
    }

    public WorkflowCreate transitions(List<TransitionUpdateDTO> transitions) {
        this.transitions = transitions;
        return this;
    }

    public WorkflowCreate addTransitionsItem(TransitionUpdateDTO transitionsItem) {
        this.transitions.add(transitionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The transitions of this workflow.")
    public List<TransitionUpdateDTO> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(List<TransitionUpdateDTO> transitions) {
        this.transitions = transitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowCreate workflowCreate = (WorkflowCreate)o;
        return Objects.equals(this.description, workflowCreate.description) && Objects.equals(this.name, workflowCreate.name) && Objects.equals(this.startPointLayout, workflowCreate.startPointLayout) && Objects.equals(this.statuses, workflowCreate.statuses) && Objects.equals(this.transitions, workflowCreate.transitions);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.startPointLayout, this.statuses, this.transitions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowCreate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startPointLayout: ").append(this.toIndentedString(this.startPointLayout)).append("\n");
        sb.append("    statuses: ").append(this.toIndentedString(this.statuses)).append("\n");
        sb.append("    transitions: ").append(this.toIndentedString(this.transitions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

