/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.AvailableWorkflowConnectRule;
import org.everit.atlassian.restclient.jiracloud.v2.model.AvailableWorkflowForgeRule;
import org.everit.atlassian.restclient.jiracloud.v2.model.AvailableWorkflowSystemRule;
import org.everit.atlassian.restclient.jiracloud.v2.model.AvailableWorkflowTriggers;

public class WorkflowCapabilities {
    @JsonProperty(value="connectRules")
    private List<AvailableWorkflowConnectRule> connectRules = new ArrayList<AvailableWorkflowConnectRule>();
    @JsonProperty(value="editorScope")
    private EditorScopeEnum editorScope;
    @JsonProperty(value="forgeRules")
    private List<AvailableWorkflowForgeRule> forgeRules = new ArrayList<AvailableWorkflowForgeRule>();
    @JsonProperty(value="projectTypes")
    private List<ProjectTypesEnum> projectTypes = new ArrayList<ProjectTypesEnum>();
    @JsonProperty(value="systemRules")
    private List<AvailableWorkflowSystemRule> systemRules = new ArrayList<AvailableWorkflowSystemRule>();
    @JsonProperty(value="triggerRules")
    private List<AvailableWorkflowTriggers> triggerRules = new ArrayList<AvailableWorkflowTriggers>();

    public WorkflowCapabilities connectRules(List<AvailableWorkflowConnectRule> connectRules) {
        this.connectRules = connectRules;
        return this;
    }

    public WorkflowCapabilities addConnectRulesItem(AvailableWorkflowConnectRule connectRulesItem) {
        if (this.connectRules == null) {
            this.connectRules = new ArrayList<AvailableWorkflowConnectRule>();
        }
        this.connectRules.add(connectRulesItem);
        return this;
    }

    @ApiModelProperty(value="The Connect provided ecosystem rules available.")
    public List<AvailableWorkflowConnectRule> getConnectRules() {
        return this.connectRules;
    }

    public void setConnectRules(List<AvailableWorkflowConnectRule> connectRules) {
        this.connectRules = connectRules;
    }

    public WorkflowCapabilities editorScope(EditorScopeEnum editorScope) {
        this.editorScope = editorScope;
        return this;
    }

    @ApiModelProperty(value="The scope of the workflow capabilities. `GLOBAL` for company-managed projects and `PROJECT` for team-managed projects.")
    public EditorScopeEnum getEditorScope() {
        return this.editorScope;
    }

    public void setEditorScope(EditorScopeEnum editorScope) {
        this.editorScope = editorScope;
    }

    public WorkflowCapabilities forgeRules(List<AvailableWorkflowForgeRule> forgeRules) {
        this.forgeRules = forgeRules;
        return this;
    }

    public WorkflowCapabilities addForgeRulesItem(AvailableWorkflowForgeRule forgeRulesItem) {
        if (this.forgeRules == null) {
            this.forgeRules = new ArrayList<AvailableWorkflowForgeRule>();
        }
        this.forgeRules.add(forgeRulesItem);
        return this;
    }

    @ApiModelProperty(value="The Forge provided ecosystem rules available.")
    public List<AvailableWorkflowForgeRule> getForgeRules() {
        return this.forgeRules;
    }

    public void setForgeRules(List<AvailableWorkflowForgeRule> forgeRules) {
        this.forgeRules = forgeRules;
    }

    public WorkflowCapabilities projectTypes(List<ProjectTypesEnum> projectTypes) {
        this.projectTypes = projectTypes;
        return this;
    }

    public WorkflowCapabilities addProjectTypesItem(ProjectTypesEnum projectTypesItem) {
        if (this.projectTypes == null) {
            this.projectTypes = new ArrayList<ProjectTypesEnum>();
        }
        this.projectTypes.add(projectTypesItem);
        return this;
    }

    @ApiModelProperty(value="The types of projects that this capability set is available for.")
    public List<ProjectTypesEnum> getProjectTypes() {
        return this.projectTypes;
    }

    public void setProjectTypes(List<ProjectTypesEnum> projectTypes) {
        this.projectTypes = projectTypes;
    }

    public WorkflowCapabilities systemRules(List<AvailableWorkflowSystemRule> systemRules) {
        this.systemRules = systemRules;
        return this;
    }

    public WorkflowCapabilities addSystemRulesItem(AvailableWorkflowSystemRule systemRulesItem) {
        if (this.systemRules == null) {
            this.systemRules = new ArrayList<AvailableWorkflowSystemRule>();
        }
        this.systemRules.add(systemRulesItem);
        return this;
    }

    @ApiModelProperty(value="The Atlassian provided system rules available.")
    public List<AvailableWorkflowSystemRule> getSystemRules() {
        return this.systemRules;
    }

    public void setSystemRules(List<AvailableWorkflowSystemRule> systemRules) {
        this.systemRules = systemRules;
    }

    public WorkflowCapabilities triggerRules(List<AvailableWorkflowTriggers> triggerRules) {
        this.triggerRules = triggerRules;
        return this;
    }

    public WorkflowCapabilities addTriggerRulesItem(AvailableWorkflowTriggers triggerRulesItem) {
        if (this.triggerRules == null) {
            this.triggerRules = new ArrayList<AvailableWorkflowTriggers>();
        }
        this.triggerRules.add(triggerRulesItem);
        return this;
    }

    @ApiModelProperty(value="The trigger rules available.")
    public List<AvailableWorkflowTriggers> getTriggerRules() {
        return this.triggerRules;
    }

    public void setTriggerRules(List<AvailableWorkflowTriggers> triggerRules) {
        this.triggerRules = triggerRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowCapabilities workflowCapabilities = (WorkflowCapabilities)o;
        return Objects.equals(this.connectRules, workflowCapabilities.connectRules) && Objects.equals((Object)this.editorScope, (Object)workflowCapabilities.editorScope) && Objects.equals(this.forgeRules, workflowCapabilities.forgeRules) && Objects.equals(this.projectTypes, workflowCapabilities.projectTypes) && Objects.equals(this.systemRules, workflowCapabilities.systemRules) && Objects.equals(this.triggerRules, workflowCapabilities.triggerRules);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectRules, this.editorScope, this.forgeRules, this.projectTypes, this.systemRules, this.triggerRules});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowCapabilities {\n");
        sb.append("    connectRules: ").append(this.toIndentedString(this.connectRules)).append("\n");
        sb.append("    editorScope: ").append(this.toIndentedString((Object)this.editorScope)).append("\n");
        sb.append("    forgeRules: ").append(this.toIndentedString(this.forgeRules)).append("\n");
        sb.append("    projectTypes: ").append(this.toIndentedString(this.projectTypes)).append("\n");
        sb.append("    systemRules: ").append(this.toIndentedString(this.systemRules)).append("\n");
        sb.append("    triggerRules: ").append(this.toIndentedString(this.triggerRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProjectTypesEnum {
        SOFTWARE("software"),
        SERVICE_DESK("service_desk"),
        PRODUCT_DISCOVERY("product_discovery"),
        BUSINESS("business"),
        UNKNOWN("unknown");

        private String value;

        private ProjectTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProjectTypesEnum fromValue(String value) {
            for (ProjectTypesEnum b : ProjectTypesEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EditorScopeEnum {
        PROJECT("PROJECT"),
        GLOBAL("GLOBAL");

        private String value;

        private EditorScopeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EditorScopeEnum fromValue(String value) {
            for (EditorScopeEnum b : EditorScopeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

