/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.PublishedWorkflowId;
import org.everit.atlassian.restclient.jiracloud.v2.model.Transition;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowOperations;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowSchemeIdName;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowStatus;

@ApiModel(description="Details about a workflow.")
public class Workflow {
    @JsonProperty(value="created")
    private OffsetDateTime created;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="hasDraftWorkflow")
    private Boolean hasDraftWorkflow;
    @JsonProperty(value="id")
    private PublishedWorkflowId id;
    @JsonProperty(value="isDefault")
    private Boolean isDefault;
    @JsonProperty(value="operations")
    private WorkflowOperations operations;
    @JsonProperty(value="projects")
    private List<ProjectDetails> projects = new ArrayList<ProjectDetails>();
    @JsonProperty(value="schemes")
    private List<WorkflowSchemeIdName> schemes = new ArrayList<WorkflowSchemeIdName>();
    @JsonProperty(value="statuses")
    private List<WorkflowStatus> statuses = new ArrayList<WorkflowStatus>();
    @JsonProperty(value="transitions")
    private List<Transition> transitions = new ArrayList<Transition>();
    @JsonProperty(value="updated")
    private OffsetDateTime updated;

    public Workflow created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="The creation date of the workflow.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public Workflow description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the workflow.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Workflow hasDraftWorkflow(Boolean hasDraftWorkflow) {
        this.hasDraftWorkflow = hasDraftWorkflow;
        return this;
    }

    @ApiModelProperty(value="Whether the workflow has a draft version.")
    public Boolean getHasDraftWorkflow() {
        return this.hasDraftWorkflow;
    }

    public void setHasDraftWorkflow(Boolean hasDraftWorkflow) {
        this.hasDraftWorkflow = hasDraftWorkflow;
    }

    public Workflow id(PublishedWorkflowId id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PublishedWorkflowId getId() {
        return this.id;
    }

    public void setId(PublishedWorkflowId id) {
        this.id = id;
    }

    public Workflow isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @ApiModelProperty(value="Whether this is the default workflow.")
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Workflow operations(WorkflowOperations operations) {
        this.operations = operations;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowOperations getOperations() {
        return this.operations;
    }

    public void setOperations(WorkflowOperations operations) {
        this.operations = operations;
    }

    public Workflow projects(List<ProjectDetails> projects) {
        this.projects = projects;
        return this;
    }

    public Workflow addProjectsItem(ProjectDetails projectsItem) {
        if (this.projects == null) {
            this.projects = new ArrayList<ProjectDetails>();
        }
        this.projects.add(projectsItem);
        return this;
    }

    @ApiModelProperty(value="The projects the workflow is assigned to, through workflow schemes.")
    public List<ProjectDetails> getProjects() {
        return this.projects;
    }

    public void setProjects(List<ProjectDetails> projects) {
        this.projects = projects;
    }

    public Workflow schemes(List<WorkflowSchemeIdName> schemes) {
        this.schemes = schemes;
        return this;
    }

    public Workflow addSchemesItem(WorkflowSchemeIdName schemesItem) {
        if (this.schemes == null) {
            this.schemes = new ArrayList<WorkflowSchemeIdName>();
        }
        this.schemes.add(schemesItem);
        return this;
    }

    @ApiModelProperty(value="The workflow schemes the workflow is assigned to.")
    public List<WorkflowSchemeIdName> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(List<WorkflowSchemeIdName> schemes) {
        this.schemes = schemes;
    }

    public Workflow statuses(List<WorkflowStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public Workflow addStatusesItem(WorkflowStatus statusesItem) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<WorkflowStatus>();
        }
        this.statuses.add(statusesItem);
        return this;
    }

    @ApiModelProperty(value="The statuses of the workflow.")
    public List<WorkflowStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<WorkflowStatus> statuses) {
        this.statuses = statuses;
    }

    public Workflow transitions(List<Transition> transitions) {
        this.transitions = transitions;
        return this;
    }

    public Workflow addTransitionsItem(Transition transitionsItem) {
        if (this.transitions == null) {
            this.transitions = new ArrayList<Transition>();
        }
        this.transitions.add(transitionsItem);
        return this;
    }

    @ApiModelProperty(value="The transitions of the workflow.")
    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(List<Transition> transitions) {
        this.transitions = transitions;
    }

    public Workflow updated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    @ApiModelProperty(value="The last edited date of the workflow.")
    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public void setUpdated(OffsetDateTime updated) {
        this.updated = updated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workflow workflow = (Workflow)o;
        return Objects.equals(this.created, workflow.created) && Objects.equals(this.description, workflow.description) && Objects.equals(this.hasDraftWorkflow, workflow.hasDraftWorkflow) && Objects.equals(this.id, workflow.id) && Objects.equals(this.isDefault, workflow.isDefault) && Objects.equals(this.operations, workflow.operations) && Objects.equals(this.projects, workflow.projects) && Objects.equals(this.schemes, workflow.schemes) && Objects.equals(this.statuses, workflow.statuses) && Objects.equals(this.transitions, workflow.transitions) && Objects.equals(this.updated, workflow.updated);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.description, this.hasDraftWorkflow, this.id, this.isDefault, this.operations, this.projects, this.schemes, this.statuses, this.transitions, this.updated);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Workflow {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    hasDraftWorkflow: ").append(this.toIndentedString(this.hasDraftWorkflow)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("    schemes: ").append(this.toIndentedString(this.schemes)).append("\n");
        sb.append("    statuses: ").append(this.toIndentedString(this.statuses)).append("\n");
        sb.append("    transitions: ").append(this.toIndentedString(this.transitions)).append("\n");
        sb.append("    updated: ").append(this.toIndentedString(this.updated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

