/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A webhook.")
public class Webhook {
    @JsonProperty(value="events")
    private List<EventsEnum> events = new ArrayList<EventsEnum>();
    @JsonProperty(value="expirationDate")
    private Long expirationDate;
    @JsonProperty(value="fieldIdsFilter")
    private List<String> fieldIdsFilter = new ArrayList<String>();
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="issuePropertyKeysFilter")
    private List<String> issuePropertyKeysFilter = new ArrayList<String>();
    @JsonProperty(value="jqlFilter")
    private String jqlFilter;

    public Webhook events(List<EventsEnum> events) {
        this.events = events;
        return this;
    }

    public Webhook addEventsItem(EventsEnum eventsItem) {
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The Jira events that trigger the webhook.")
    public List<EventsEnum> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventsEnum> events) {
        this.events = events;
    }

    @ApiModelProperty(value="The date after which the webhook is no longer sent. Use [Extend webhook life](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-webhooks/#api-rest-api-3-webhook-refresh-put) to extend the date.")
    public Long getExpirationDate() {
        return this.expirationDate;
    }

    public Webhook fieldIdsFilter(List<String> fieldIdsFilter) {
        this.fieldIdsFilter = fieldIdsFilter;
        return this;
    }

    public Webhook addFieldIdsFilterItem(String fieldIdsFilterItem) {
        if (this.fieldIdsFilter == null) {
            this.fieldIdsFilter = new ArrayList<String>();
        }
        this.fieldIdsFilter.add(fieldIdsFilterItem);
        return this;
    }

    @ApiModelProperty(value="A list of field IDs. When the issue changelog contains any of the fields, the webhook `jira:issue_updated` is sent. If this parameter is not present, the app is notified about all field updates.")
    public List<String> getFieldIdsFilter() {
        return this.fieldIdsFilter;
    }

    public void setFieldIdsFilter(List<String> fieldIdsFilter) {
        this.fieldIdsFilter = fieldIdsFilter;
    }

    public Webhook id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the webhook.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Webhook issuePropertyKeysFilter(List<String> issuePropertyKeysFilter) {
        this.issuePropertyKeysFilter = issuePropertyKeysFilter;
        return this;
    }

    public Webhook addIssuePropertyKeysFilterItem(String issuePropertyKeysFilterItem) {
        if (this.issuePropertyKeysFilter == null) {
            this.issuePropertyKeysFilter = new ArrayList<String>();
        }
        this.issuePropertyKeysFilter.add(issuePropertyKeysFilterItem);
        return this;
    }

    @ApiModelProperty(value="A list of issue property keys. A change of those issue properties triggers the `issue_property_set` or `issue_property_deleted` webhooks. If this parameter is not present, the app is notified about all issue property updates.")
    public List<String> getIssuePropertyKeysFilter() {
        return this.issuePropertyKeysFilter;
    }

    public void setIssuePropertyKeysFilter(List<String> issuePropertyKeysFilter) {
        this.issuePropertyKeysFilter = issuePropertyKeysFilter;
    }

    public Webhook jqlFilter(String jqlFilter) {
        this.jqlFilter = jqlFilter;
        return this;
    }

    @ApiModelProperty(required=true, value="The JQL filter that specifies which issues the webhook is sent for.")
    public String getJqlFilter() {
        return this.jqlFilter;
    }

    public void setJqlFilter(String jqlFilter) {
        this.jqlFilter = jqlFilter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.events, webhook.events) && Objects.equals(this.expirationDate, webhook.expirationDate) && Objects.equals(this.fieldIdsFilter, webhook.fieldIdsFilter) && Objects.equals(this.id, webhook.id) && Objects.equals(this.issuePropertyKeysFilter, webhook.issuePropertyKeysFilter) && Objects.equals(this.jqlFilter, webhook.jqlFilter);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.expirationDate, this.fieldIdsFilter, this.id, this.issuePropertyKeysFilter, this.jqlFilter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    fieldIdsFilter: ").append(this.toIndentedString(this.fieldIdsFilter)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issuePropertyKeysFilter: ").append(this.toIndentedString(this.issuePropertyKeysFilter)).append("\n");
        sb.append("    jqlFilter: ").append(this.toIndentedString(this.jqlFilter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventsEnum {
        JIRA_ISSUE_CREATED("jira:issue_created"),
        JIRA_ISSUE_UPDATED("jira:issue_updated"),
        JIRA_ISSUE_DELETED("jira:issue_deleted"),
        COMMENT_CREATED("comment_created"),
        COMMENT_UPDATED("comment_updated"),
        COMMENT_DELETED("comment_deleted"),
        ISSUE_PROPERTY_SET("issue_property_set"),
        ISSUE_PROPERTY_DELETED("issue_property_deleted");

        private String value;

        private EventsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventsEnum fromValue(String value) {
            for (EventsEnum b : EventsEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

