/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;

@ApiModel(description="Associated related work to a version")
public class VersionRelatedWork {
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="issueId")
    private Long issueId;
    @JsonProperty(value="relatedWorkId")
    private String relatedWorkId;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="url")
    private URI url;

    @ApiModelProperty(required=true, value="The category of the related work")
    public String getCategory() {
        return this.category;
    }

    @ApiModelProperty(value="The title of the related work")
    public Long getIssueId() {
        return this.issueId;
    }

    @ApiModelProperty(value="The id of the related work. For the native release note related work item, this will be null, and Rest API does not support updating it.")
    public String getRelatedWorkId() {
        return this.relatedWorkId;
    }

    @ApiModelProperty(value="The title of the related work")
    public String getTitle() {
        return this.title;
    }

    @ApiModelProperty(value="The URL of the related work")
    public URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionRelatedWork versionRelatedWork = (VersionRelatedWork)o;
        return Objects.equals(this.category, versionRelatedWork.category) && Objects.equals(this.issueId, versionRelatedWork.issueId) && Objects.equals(this.relatedWorkId, versionRelatedWork.relatedWorkId) && Objects.equals(this.title, versionRelatedWork.title) && Objects.equals(this.url, versionRelatedWork.url);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.issueId, this.relatedWorkId, this.title, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VersionRelatedWork {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    issueId: ").append(this.toIndentedString(this.issueId)).append("\n");
        sb.append("    relatedWorkId: ").append(this.toIndentedString(this.relatedWorkId)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

