/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Contains details about a version approver.")
public class VersionApprover {
    @JsonProperty(value="accountId")
    private String accountId;
    @JsonProperty(value="declineReason")
    private String declineReason;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="status")
    private String status;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    @ApiModelProperty(value="The Atlassian account ID of the approver.")
    public String getAccountId() {
        return this.accountId;
    }

    @ApiModelProperty(value="A description of why the user is declining the approval.")
    public String getDeclineReason() {
        return this.declineReason;
    }

    @ApiModelProperty(value="A description of what the user is approving within the specified version.")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="The status of the approval, which can be *PENDING*, *APPROVED*, or *DECLINED*")
    public String getStatus() {
        return this.status;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionApprover versionApprover = (VersionApprover)o;
        return Objects.equals(this.accountId, versionApprover.accountId) && Objects.equals(this.declineReason, versionApprover.declineReason) && Objects.equals(this.description, versionApprover.description) && Objects.equals(this.status, versionApprover.status) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.declineReason, this.description, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VersionApprover {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    declineReason: ").append(this.toIndentedString(this.declineReason)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

