/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.SimpleLink;
import org.everit.atlassian.restclient.jiracloud.v2.model.VersionApprover;
import org.everit.atlassian.restclient.jiracloud.v2.model.VersionIssuesStatus;

@ApiModel(description="Details about a project version.")
public class Version {
    @JsonProperty(value="approvers")
    private List<VersionApprover> approvers = new ArrayList<VersionApprover>();
    @JsonProperty(value="archived")
    private Boolean archived;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="driver")
    private String driver;
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="issuesStatusForFixVersion")
    private VersionIssuesStatus issuesStatusForFixVersion;
    @JsonProperty(value="moveUnfixedIssuesTo")
    private URI moveUnfixedIssuesTo;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="operations")
    private List<SimpleLink> operations = new ArrayList<SimpleLink>();
    @JsonProperty(value="overdue")
    private Boolean overdue;
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="projectId")
    private Long projectId;
    @JsonProperty(value="releaseDate")
    private LocalDate releaseDate;
    @JsonProperty(value="released")
    private Boolean released;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="startDate")
    private LocalDate startDate;
    @JsonProperty(value="userReleaseDate")
    private String userReleaseDate;
    @JsonProperty(value="userStartDate")
    private String userStartDate;

    @ApiModelProperty(value="If the expand option `approvers` is used, returns a list containing the approvers for this version.")
    public List<VersionApprover> getApprovers() {
        return this.approvers;
    }

    public Version archived(Boolean archived) {
        this.archived = archived;
        return this;
    }

    @ApiModelProperty(value="Indicates that the version is archived. Optional when creating or updating a version.")
    public Boolean getArchived() {
        return this.archived;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public Version description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the version. Optional when creating or updating a version. The maximum size is 16,384 bytes.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="If the expand option `driver` is used, returns the Atlassian account ID of the driver.")
    public String getDriver() {
        return this.driver;
    }

    public Version expand(String expand) {
        this.expand = expand;
        return this;
    }

    @ApiModelProperty(value="Use [expand](em>#expansion) to include additional information about version in the response. This parameter accepts a comma-separated list. Expand options include:   *  `operations` Returns the list of operations available for this version.  *  `issuesstatus` Returns the count of issues in this version for each of the status categories *to do*, *in progress*, *done*, and *unmapped*. The *unmapped* property contains a count of issues with a status other than *to do*, *in progress*, and *done*.  *  `driver` Returns the Atlassian account ID of the version driver.  *  `approvers` Returns a list containing approvers for this version.  Optional for create and update.")
    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    @ApiModelProperty(value="The ID of the version.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="If the expand option `issuesstatus` is used, returns the count of issues in this version for each of the status categories *to do*, *in progress*, *done*, and *unmapped*. The *unmapped* property contains a count of issues with a status other than *to do*, *in progress*, and *done*.")
    public VersionIssuesStatus getIssuesStatusForFixVersion() {
        return this.issuesStatusForFixVersion;
    }

    public Version moveUnfixedIssuesTo(URI moveUnfixedIssuesTo) {
        this.moveUnfixedIssuesTo = moveUnfixedIssuesTo;
        return this;
    }

    @ApiModelProperty(value="The URL of the self link to the version to which all unfixed issues are moved when a version is released. Not applicable when creating a version. Optional when updating a version.")
    public URI getMoveUnfixedIssuesTo() {
        return this.moveUnfixedIssuesTo;
    }

    public void setMoveUnfixedIssuesTo(URI moveUnfixedIssuesTo) {
        this.moveUnfixedIssuesTo = moveUnfixedIssuesTo;
    }

    public Version name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The unique name of the version. Required when creating a version. Optional when updating a version. The maximum length is 255 characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="If the expand option `operations` is used, returns the list of operations available for this version.")
    public List<SimpleLink> getOperations() {
        return this.operations;
    }

    @ApiModelProperty(value="Indicates that the version is overdue.")
    public Boolean getOverdue() {
        return this.overdue;
    }

    public Version project(String project) {
        this.project = project;
        return this;
    }

    @ApiModelProperty(value="Deprecated. Use `projectId`.")
    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public Version projectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(value="The ID of the project to which this version is attached. Required when creating a version. Not applicable when updating a version.")
    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Version releaseDate(LocalDate releaseDate) {
        this.releaseDate = releaseDate;
        return this;
    }

    @ApiModelProperty(value="The release date of the version. Expressed in ISO 8601 format (yyyy-mm-dd). Optional when creating or updating a version.")
    public LocalDate getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(LocalDate releaseDate) {
        this.releaseDate = releaseDate;
    }

    public Version released(Boolean released) {
        this.released = released;
        return this;
    }

    @ApiModelProperty(value="Indicates that the version is released. If the version is released a request to release again is ignored. Not applicable when creating a version. Optional when updating a version.")
    public Boolean getReleased() {
        return this.released;
    }

    public void setReleased(Boolean released) {
        this.released = released;
    }

    @ApiModelProperty(value="The URL of the version.")
    public URI getSelf() {
        return this.self;
    }

    public Version startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="The start date of the version. Expressed in ISO 8601 format (yyyy-mm-dd). Optional when creating or updating a version.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @ApiModelProperty(value="The date on which work on this version is expected to finish, expressed in the instance's *Day/Month/Year Format* date format.")
    public String getUserReleaseDate() {
        return this.userReleaseDate;
    }

    @ApiModelProperty(value="The date on which work on this version is expected to start, expressed in the instance's *Day/Month/Year Format* date format.")
    public String getUserStartDate() {
        return this.userStartDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return Objects.equals(this.approvers, version.approvers) && Objects.equals(this.archived, version.archived) && Objects.equals(this.description, version.description) && Objects.equals(this.driver, version.driver) && Objects.equals(this.expand, version.expand) && Objects.equals(this.id, version.id) && Objects.equals(this.issuesStatusForFixVersion, version.issuesStatusForFixVersion) && Objects.equals(this.moveUnfixedIssuesTo, version.moveUnfixedIssuesTo) && Objects.equals(this.name, version.name) && Objects.equals(this.operations, version.operations) && Objects.equals(this.overdue, version.overdue) && Objects.equals(this.project, version.project) && Objects.equals(this.projectId, version.projectId) && Objects.equals(this.releaseDate, version.releaseDate) && Objects.equals(this.released, version.released) && Objects.equals(this.self, version.self) && Objects.equals(this.startDate, version.startDate) && Objects.equals(this.userReleaseDate, version.userReleaseDate) && Objects.equals(this.userStartDate, version.userStartDate);
    }

    public int hashCode() {
        return Objects.hash(this.approvers, this.archived, this.description, this.driver, this.expand, this.id, this.issuesStatusForFixVersion, this.moveUnfixedIssuesTo, this.name, this.operations, this.overdue, this.project, this.projectId, this.releaseDate, this.released, this.self, this.startDate, this.userReleaseDate, this.userStartDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Version {\n");
        sb.append("    approvers: ").append(this.toIndentedString(this.approvers)).append("\n");
        sb.append("    archived: ").append(this.toIndentedString(this.archived)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issuesStatusForFixVersion: ").append(this.toIndentedString(this.issuesStatusForFixVersion)).append("\n");
        sb.append("    moveUnfixedIssuesTo: ").append(this.toIndentedString(this.moveUnfixedIssuesTo)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    overdue: ").append(this.toIndentedString(this.overdue)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    releaseDate: ").append(this.toIndentedString(this.releaseDate)).append("\n");
        sb.append("    released: ").append(this.toIndentedString(this.released)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    userReleaseDate: ").append(this.toIndentedString(this.userReleaseDate)).append("\n");
        sb.append("    userStartDate: ").append(this.toIndentedString(this.userStartDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

