/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The details of a UI modification's context, which define where to activate the UI modification.")
public class UiModificationContextDetails {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="isAvailable")
    private Boolean isAvailable;
    @JsonProperty(value="issueTypeId")
    private String issueTypeId;
    @JsonProperty(value="projectId")
    private String projectId;
    @JsonProperty(value="viewType")
    private ViewTypeEnum viewType;

    @ApiModelProperty(value="The ID of the UI modification context.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="Whether a context is available. For example, when a project is deleted the context becomes unavailable.")
    public Boolean getIsAvailable() {
        return this.isAvailable;
    }

    public UiModificationContextDetails issueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
        return this;
    }

    @ApiModelProperty(required=true, value="The issue type ID of the context.")
    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public UiModificationContextDetails projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(required=true, value="The project ID of the context.")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public UiModificationContextDetails viewType(ViewTypeEnum viewType) {
        this.viewType = viewType;
        return this;
    }

    @ApiModelProperty(required=true, value="The view type of the context. Only `GIC`(Global Issue Create) and `IssueView` are supported.")
    public ViewTypeEnum getViewType() {
        return this.viewType;
    }

    public void setViewType(ViewTypeEnum viewType) {
        this.viewType = viewType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UiModificationContextDetails uiModificationContextDetails = (UiModificationContextDetails)o;
        return Objects.equals(this.id, uiModificationContextDetails.id) && Objects.equals(this.isAvailable, uiModificationContextDetails.isAvailable) && Objects.equals(this.issueTypeId, uiModificationContextDetails.issueTypeId) && Objects.equals(this.projectId, uiModificationContextDetails.projectId) && Objects.equals((Object)this.viewType, (Object)uiModificationContextDetails.viewType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.isAvailable, this.issueTypeId, this.projectId, this.viewType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UiModificationContextDetails {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isAvailable: ").append(this.toIndentedString(this.isAvailable)).append("\n");
        sb.append("    issueTypeId: ").append(this.toIndentedString(this.issueTypeId)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    viewType: ").append(this.toIndentedString((Object)this.viewType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ViewTypeEnum {
        GIC("GIC"),
        ISSUEVIEW("IssueView");

        private String value;

        private ViewTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ViewTypeEnum fromValue(String value) {
            for (ViewTypeEnum b : ViewTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

