/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Time tracking details.")
public class TimeTrackingDetails {
    @JsonProperty(value="originalEstimate")
    private String originalEstimate;
    @JsonProperty(value="originalEstimateSeconds")
    private Long originalEstimateSeconds;
    @JsonProperty(value="remainingEstimate")
    private String remainingEstimate;
    @JsonProperty(value="remainingEstimateSeconds")
    private Long remainingEstimateSeconds;
    @JsonProperty(value="timeSpent")
    private String timeSpent;
    @JsonProperty(value="timeSpentSeconds")
    private Long timeSpentSeconds;

    @ApiModelProperty(value="The original estimate of time needed for this issue in readable format.")
    public String getOriginalEstimate() {
        return this.originalEstimate;
    }

    @ApiModelProperty(value="The original estimate of time needed for this issue in seconds.")
    public Long getOriginalEstimateSeconds() {
        return this.originalEstimateSeconds;
    }

    @ApiModelProperty(value="The remaining estimate of time needed for this issue in readable format.")
    public String getRemainingEstimate() {
        return this.remainingEstimate;
    }

    @ApiModelProperty(value="The remaining estimate of time needed for this issue in seconds.")
    public Long getRemainingEstimateSeconds() {
        return this.remainingEstimateSeconds;
    }

    @ApiModelProperty(value="Time worked on this issue in readable format.")
    public String getTimeSpent() {
        return this.timeSpent;
    }

    @ApiModelProperty(value="Time worked on this issue in seconds.")
    public Long getTimeSpentSeconds() {
        return this.timeSpentSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeTrackingDetails timeTrackingDetails = (TimeTrackingDetails)o;
        return Objects.equals(this.originalEstimate, timeTrackingDetails.originalEstimate) && Objects.equals(this.originalEstimateSeconds, timeTrackingDetails.originalEstimateSeconds) && Objects.equals(this.remainingEstimate, timeTrackingDetails.remainingEstimate) && Objects.equals(this.remainingEstimateSeconds, timeTrackingDetails.remainingEstimateSeconds) && Objects.equals(this.timeSpent, timeTrackingDetails.timeSpent) && Objects.equals(this.timeSpentSeconds, timeTrackingDetails.timeSpentSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.originalEstimate, this.originalEstimateSeconds, this.remainingEstimate, this.remainingEstimateSeconds, this.timeSpent, this.timeSpentSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeTrackingDetails {\n");
        sb.append("    originalEstimate: ").append(this.toIndentedString(this.originalEstimate)).append("\n");
        sb.append("    originalEstimateSeconds: ").append(this.toIndentedString(this.originalEstimateSeconds)).append("\n");
        sb.append("    remainingEstimate: ").append(this.toIndentedString(this.remainingEstimate)).append("\n");
        sb.append("    remainingEstimateSeconds: ").append(this.toIndentedString(this.remainingEstimateSeconds)).append("\n");
        sb.append("    timeSpent: ").append(this.toIndentedString(this.timeSpent)).append("\n");
        sb.append("    timeSpentSeconds: ").append(this.toIndentedString(this.timeSpentSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

