/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a usage of an entity by a project ID and related issue type IDs.")
public class SimpleUsage {
    @JsonProperty(value="issueTypeIds")
    private List<String> issueTypeIds = new ArrayList<String>();
    @JsonProperty(value="projectId")
    private String projectId;

    public SimpleUsage issueTypeIds(List<String> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
        return this;
    }

    public SimpleUsage addIssueTypeIdsItem(String issueTypeIdsItem) {
        this.issueTypeIds.add(issueTypeIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The issue type IDs for the usage.")
    public List<String> getIssueTypeIds() {
        return this.issueTypeIds;
    }

    public void setIssueTypeIds(List<String> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
    }

    public SimpleUsage projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(required=true, value="The project ID for the usage.")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleUsage simpleUsage = (SimpleUsage)o;
        return Objects.equals(this.issueTypeIds, simpleUsage.issueTypeIds) && Objects.equals(this.projectId, simpleUsage.projectId);
    }

    public int hashCode() {
        return Objects.hash(this.issueTypeIds, this.projectId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimpleUsage {\n");
        sb.append("    issueTypeIds: ").append(this.toIndentedString(this.issueTypeIds)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

