/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanIssueTypeScreenScheme;
import org.everit.atlassian.restclient.jiracloud.v2.model.ScreenTypes;

@ApiModel(description="A screen scheme.")
public class ScreenScheme {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="issueTypeScreenSchemes")
    private PageBeanIssueTypeScreenScheme issueTypeScreenSchemes;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="screens")
    private ScreenTypes screens;

    public ScreenScheme description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the screen scheme.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScreenScheme id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the screen scheme.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ScreenScheme issueTypeScreenSchemes(PageBeanIssueTypeScreenScheme issueTypeScreenSchemes) {
        this.issueTypeScreenSchemes = issueTypeScreenSchemes;
        return this;
    }

    @ApiModelProperty(value="Details of the issue type screen schemes associated with the screen scheme.")
    public PageBeanIssueTypeScreenScheme getIssueTypeScreenSchemes() {
        return this.issueTypeScreenSchemes;
    }

    public void setIssueTypeScreenSchemes(PageBeanIssueTypeScreenScheme issueTypeScreenSchemes) {
        this.issueTypeScreenSchemes = issueTypeScreenSchemes;
    }

    public ScreenScheme name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the screen scheme.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ScreenScheme screens(ScreenTypes screens) {
        this.screens = screens;
        return this;
    }

    @ApiModelProperty(value="The IDs of the screens for the screen types of the screen scheme.")
    public ScreenTypes getScreens() {
        return this.screens;
    }

    public void setScreens(ScreenTypes screens) {
        this.screens = screens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenScheme screenScheme = (ScreenScheme)o;
        return Objects.equals(this.description, screenScheme.description) && Objects.equals(this.id, screenScheme.id) && Objects.equals(this.issueTypeScreenSchemes, screenScheme.issueTypeScreenSchemes) && Objects.equals(this.name, screenScheme.name) && Objects.equals(this.screens, screenScheme.screens);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.id, this.issueTypeScreenSchemes, this.name, this.screens);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScreenScheme {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issueTypeScreenSchemes: ").append(this.toIndentedString(this.issueTypeScreenSchemes)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    screens: ").append(this.toIndentedString(this.screens)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

