/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details of a project feature.")
public class ProjectFeature {
    @JsonProperty(value="feature")
    private String feature;
    @JsonProperty(value="imageUri")
    private String imageUri;
    @JsonProperty(value="localisedDescription")
    private String localisedDescription;
    @JsonProperty(value="localisedName")
    private String localisedName;
    @JsonProperty(value="prerequisites")
    private List<String> prerequisites = new ArrayList<String>();
    @JsonProperty(value="projectId")
    private Long projectId;
    @JsonProperty(value="state")
    private StateEnum state;
    @JsonProperty(value="toggleLocked")
    private Boolean toggleLocked;

    public ProjectFeature feature(String feature) {
        this.feature = feature;
        return this;
    }

    @ApiModelProperty(value="The key of the feature.")
    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public ProjectFeature imageUri(String imageUri) {
        this.imageUri = imageUri;
        return this;
    }

    @ApiModelProperty(value="URI for the image representing the feature.")
    public String getImageUri() {
        return this.imageUri;
    }

    public void setImageUri(String imageUri) {
        this.imageUri = imageUri;
    }

    public ProjectFeature localisedDescription(String localisedDescription) {
        this.localisedDescription = localisedDescription;
        return this;
    }

    @ApiModelProperty(value="Localized display description for the feature.")
    public String getLocalisedDescription() {
        return this.localisedDescription;
    }

    public void setLocalisedDescription(String localisedDescription) {
        this.localisedDescription = localisedDescription;
    }

    public ProjectFeature localisedName(String localisedName) {
        this.localisedName = localisedName;
        return this;
    }

    @ApiModelProperty(value="Localized display name for the feature.")
    public String getLocalisedName() {
        return this.localisedName;
    }

    public void setLocalisedName(String localisedName) {
        this.localisedName = localisedName;
    }

    public ProjectFeature prerequisites(List<String> prerequisites) {
        this.prerequisites = prerequisites;
        return this;
    }

    public ProjectFeature addPrerequisitesItem(String prerequisitesItem) {
        if (this.prerequisites == null) {
            this.prerequisites = new ArrayList<String>();
        }
        this.prerequisites.add(prerequisitesItem);
        return this;
    }

    @ApiModelProperty(value="List of keys of the features required to enable the feature.")
    public List<String> getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(List<String> prerequisites) {
        this.prerequisites = prerequisites;
    }

    public ProjectFeature projectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(value="The ID of the project.")
    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public ProjectFeature state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="The state of the feature. When updating the state of a feature, only ENABLED and DISABLED are supported. Responses can contain all values")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public ProjectFeature toggleLocked(Boolean toggleLocked) {
        this.toggleLocked = toggleLocked;
        return this;
    }

    @ApiModelProperty(value="Whether the state of the feature can be updated.")
    public Boolean getToggleLocked() {
        return this.toggleLocked;
    }

    public void setToggleLocked(Boolean toggleLocked) {
        this.toggleLocked = toggleLocked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectFeature projectFeature = (ProjectFeature)o;
        return Objects.equals(this.feature, projectFeature.feature) && Objects.equals(this.imageUri, projectFeature.imageUri) && Objects.equals(this.localisedDescription, projectFeature.localisedDescription) && Objects.equals(this.localisedName, projectFeature.localisedName) && Objects.equals(this.prerequisites, projectFeature.prerequisites) && Objects.equals(this.projectId, projectFeature.projectId) && Objects.equals((Object)this.state, (Object)projectFeature.state) && Objects.equals(this.toggleLocked, projectFeature.toggleLocked);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feature, this.imageUri, this.localisedDescription, this.localisedName, this.prerequisites, this.projectId, this.state, this.toggleLocked});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectFeature {\n");
        sb.append("    feature: ").append(this.toIndentedString(this.feature)).append("\n");
        sb.append("    imageUri: ").append(this.toIndentedString(this.imageUri)).append("\n");
        sb.append("    localisedDescription: ").append(this.toIndentedString(this.localisedDescription)).append("\n");
        sb.append("    localisedName: ").append(this.toIndentedString(this.localisedName)).append("\n");
        sb.append("    prerequisites: ").append(this.toIndentedString(this.prerequisites)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    toggleLocked: ").append(this.toIndentedString(this.toggleLocked)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        ENABLED("ENABLED"),
        DISABLED("DISABLED"),
        COMING_SOON("COMING_SOON");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

