/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.everit.atlassian.restclient.jiracloud.v2.model.AvatarUrlsBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.Hierarchy;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueTypeDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectCategory;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectComponent;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectInsight;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectLandingPageInfo;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectPermissions;
import org.everit.atlassian.restclient.jiracloud.v2.model.User;
import org.everit.atlassian.restclient.jiracloud.v2.model.Version;

@ApiModel(description="Details about a project.")
public class Project {
    @JsonProperty(value="archived")
    private Boolean archived;
    @JsonProperty(value="archivedBy")
    private User archivedBy;
    @JsonProperty(value="archivedDate")
    private OffsetDateTime archivedDate;
    @JsonProperty(value="assigneeType")
    private AssigneeTypeEnum assigneeType;
    @JsonProperty(value="avatarUrls")
    private AvatarUrlsBean avatarUrls;
    @JsonProperty(value="components")
    private List<ProjectComponent> components = new ArrayList<ProjectComponent>();
    @JsonProperty(value="deleted")
    private Boolean deleted;
    @JsonProperty(value="deletedBy")
    private User deletedBy;
    @JsonProperty(value="deletedDate")
    private OffsetDateTime deletedDate;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="favourite")
    private Boolean favourite;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="insight")
    private ProjectInsight insight;
    @JsonProperty(value="isPrivate")
    private Boolean isPrivate;
    @JsonProperty(value="issueTypeHierarchy")
    private Hierarchy issueTypeHierarchy;
    @JsonProperty(value="issueTypes")
    private List<IssueTypeDetails> issueTypes = new ArrayList<IssueTypeDetails>();
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="landingPageInfo")
    private ProjectLandingPageInfo landingPageInfo;
    @JsonProperty(value="lead")
    private User lead;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="permissions")
    private ProjectPermissions permissions;
    @JsonProperty(value="projectCategory")
    private ProjectCategory projectCategory;
    @JsonProperty(value="projectTypeKey")
    private ProjectTypeKeyEnum projectTypeKey;
    @JsonProperty(value="properties")
    private Map<String, Object> properties = new HashMap<String, Object>();
    @JsonProperty(value="retentionTillDate")
    private OffsetDateTime retentionTillDate;
    @JsonProperty(value="roles")
    private Map<String, URI> roles = new HashMap<String, URI>();
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="simplified")
    private Boolean simplified;
    @JsonProperty(value="style")
    private StyleEnum style;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="uuid")
    private UUID uuid;
    @JsonProperty(value="versions")
    private List<Version> versions = new ArrayList<Version>();

    @ApiModelProperty(value="Whether the project is archived.")
    public Boolean getArchived() {
        return this.archived;
    }

    @ApiModelProperty(value="The user who archived the project.")
    public User getArchivedBy() {
        return this.archivedBy;
    }

    @ApiModelProperty(value="The date when the project was archived.")
    public OffsetDateTime getArchivedDate() {
        return this.archivedDate;
    }

    @ApiModelProperty(value="The default assignee when creating issues for this project.")
    public AssigneeTypeEnum getAssigneeType() {
        return this.assigneeType;
    }

    @ApiModelProperty(value="The URLs of the project's avatars.")
    public AvatarUrlsBean getAvatarUrls() {
        return this.avatarUrls;
    }

    @ApiModelProperty(value="List of the components contained in the project.")
    public List<ProjectComponent> getComponents() {
        return this.components;
    }

    @ApiModelProperty(value="Whether the project is marked as deleted.")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @ApiModelProperty(value="The user who marked the project as deleted.")
    public User getDeletedBy() {
        return this.deletedBy;
    }

    @ApiModelProperty(value="The date when the project was marked as deleted.")
    public OffsetDateTime getDeletedDate() {
        return this.deletedDate;
    }

    @ApiModelProperty(value="A brief description of the project.")
    public String getDescription() {
        return this.description;
    }

    public Project email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="An email address associated with the project.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(value="Expand options that include additional project details in the response.")
    public String getExpand() {
        return this.expand;
    }

    public Project favourite(Boolean favourite) {
        this.favourite = favourite;
        return this;
    }

    @ApiModelProperty(value="Whether the project is selected as a favorite.")
    public Boolean getFavourite() {
        return this.favourite;
    }

    public void setFavourite(Boolean favourite) {
        this.favourite = favourite;
    }

    public Project id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the project.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="Insights about the project.")
    public ProjectInsight getInsight() {
        return this.insight;
    }

    @ApiModelProperty(value="Whether the project is private from the user's perspective. This means the user can't see the project or any associated issues.")
    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    @ApiModelProperty(value="The issue type hierarchy for the project.")
    public Hierarchy getIssueTypeHierarchy() {
        return this.issueTypeHierarchy;
    }

    @ApiModelProperty(value="List of the issue types available in the project.")
    public List<IssueTypeDetails> getIssueTypes() {
        return this.issueTypes;
    }

    @ApiModelProperty(value="The key of the project.")
    public String getKey() {
        return this.key;
    }

    @ApiModelProperty(value="The project landing page info.")
    public ProjectLandingPageInfo getLandingPageInfo() {
        return this.landingPageInfo;
    }

    @ApiModelProperty(value="The username of the project lead.")
    public User getLead() {
        return this.lead;
    }

    @ApiModelProperty(value="The name of the project.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="User permissions on the project")
    public ProjectPermissions getPermissions() {
        return this.permissions;
    }

    @ApiModelProperty(value="The category the project belongs to.")
    public ProjectCategory getProjectCategory() {
        return this.projectCategory;
    }

    @ApiModelProperty(value="The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes) of the project.")
    public ProjectTypeKeyEnum getProjectTypeKey() {
        return this.projectTypeKey;
    }

    @ApiModelProperty(value="Map of project properties")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @ApiModelProperty(value="The date when the project is deleted permanently.")
    public OffsetDateTime getRetentionTillDate() {
        return this.retentionTillDate;
    }

    @ApiModelProperty(value="The name and self URL for each role defined in the project. For more information, see [Create project role](#api-rest-api-2-role-post).")
    public Map<String, URI> getRoles() {
        return this.roles;
    }

    @ApiModelProperty(value="The URL of the project details.")
    public URI getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="Whether the project is simplified.")
    public Boolean getSimplified() {
        return this.simplified;
    }

    @ApiModelProperty(value="The type of the project.")
    public StyleEnum getStyle() {
        return this.style;
    }

    @ApiModelProperty(value="A link to information about this project, such as project documentation.")
    public String getUrl() {
        return this.url;
    }

    @ApiModelProperty(value="Unique ID for next-gen projects.")
    public UUID getUuid() {
        return this.uuid;
    }

    @ApiModelProperty(value="The versions defined in the project. For more information, see [Create version](#api-rest-api-2-version-post).")
    public List<Version> getVersions() {
        return this.versions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equals(this.archived, project.archived) && Objects.equals(this.archivedBy, project.archivedBy) && Objects.equals(this.archivedDate, project.archivedDate) && Objects.equals((Object)this.assigneeType, (Object)project.assigneeType) && Objects.equals(this.avatarUrls, project.avatarUrls) && Objects.equals(this.components, project.components) && Objects.equals(this.deleted, project.deleted) && Objects.equals(this.deletedBy, project.deletedBy) && Objects.equals(this.deletedDate, project.deletedDate) && Objects.equals(this.description, project.description) && Objects.equals(this.email, project.email) && Objects.equals(this.expand, project.expand) && Objects.equals(this.favourite, project.favourite) && Objects.equals(this.id, project.id) && Objects.equals(this.insight, project.insight) && Objects.equals(this.isPrivate, project.isPrivate) && Objects.equals(this.issueTypeHierarchy, project.issueTypeHierarchy) && Objects.equals(this.issueTypes, project.issueTypes) && Objects.equals(this.key, project.key) && Objects.equals(this.landingPageInfo, project.landingPageInfo) && Objects.equals(this.lead, project.lead) && Objects.equals(this.name, project.name) && Objects.equals(this.permissions, project.permissions) && Objects.equals(this.projectCategory, project.projectCategory) && Objects.equals((Object)this.projectTypeKey, (Object)project.projectTypeKey) && Objects.equals(this.properties, project.properties) && Objects.equals(this.retentionTillDate, project.retentionTillDate) && Objects.equals(this.roles, project.roles) && Objects.equals(this.self, project.self) && Objects.equals(this.simplified, project.simplified) && Objects.equals((Object)this.style, (Object)project.style) && Objects.equals(this.url, project.url) && Objects.equals(this.uuid, project.uuid) && Objects.equals(this.versions, project.versions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.archived, this.archivedBy, this.archivedDate, this.assigneeType, this.avatarUrls, this.components, this.deleted, this.deletedBy, this.deletedDate, this.description, this.email, this.expand, this.favourite, this.id, this.insight, this.isPrivate, this.issueTypeHierarchy, this.issueTypes, this.key, this.landingPageInfo, this.lead, this.name, this.permissions, this.projectCategory, this.projectTypeKey, this.properties, this.retentionTillDate, this.roles, this.self, this.simplified, this.style, this.url, this.uuid, this.versions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Project {\n");
        sb.append("    archived: ").append(this.toIndentedString(this.archived)).append("\n");
        sb.append("    archivedBy: ").append(this.toIndentedString(this.archivedBy)).append("\n");
        sb.append("    archivedDate: ").append(this.toIndentedString(this.archivedDate)).append("\n");
        sb.append("    assigneeType: ").append(this.toIndentedString((Object)this.assigneeType)).append("\n");
        sb.append("    avatarUrls: ").append(this.toIndentedString(this.avatarUrls)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    deletedBy: ").append(this.toIndentedString(this.deletedBy)).append("\n");
        sb.append("    deletedDate: ").append(this.toIndentedString(this.deletedDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    favourite: ").append(this.toIndentedString(this.favourite)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    insight: ").append(this.toIndentedString(this.insight)).append("\n");
        sb.append("    isPrivate: ").append(this.toIndentedString(this.isPrivate)).append("\n");
        sb.append("    issueTypeHierarchy: ").append(this.toIndentedString(this.issueTypeHierarchy)).append("\n");
        sb.append("    issueTypes: ").append(this.toIndentedString(this.issueTypes)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    landingPageInfo: ").append(this.toIndentedString(this.landingPageInfo)).append("\n");
        sb.append("    lead: ").append(this.toIndentedString(this.lead)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    projectCategory: ").append(this.toIndentedString(this.projectCategory)).append("\n");
        sb.append("    projectTypeKey: ").append(this.toIndentedString((Object)this.projectTypeKey)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    retentionTillDate: ").append(this.toIndentedString(this.retentionTillDate)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    simplified: ").append(this.toIndentedString(this.simplified)).append("\n");
        sb.append("    style: ").append(this.toIndentedString((Object)this.style)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StyleEnum {
        CLASSIC("classic"),
        NEXT_GEN("next-gen");

        private String value;

        private StyleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StyleEnum fromValue(String value) {
            for (StyleEnum b : StyleEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProjectTypeKeyEnum {
        SOFTWARE("software"),
        SERVICE_DESK("service_desk"),
        BUSINESS("business");

        private String value;

        private ProjectTypeKeyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProjectTypeKeyEnum fromValue(String value) {
            for (ProjectTypeKeyEnum b : ProjectTypeKeyEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AssigneeTypeEnum {
        PROJECT_LEAD("PROJECT_LEAD"),
        UNASSIGNED("UNASSIGNED");

        private String value;

        private AssigneeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AssigneeTypeEnum fromValue(String value) {
            for (AssigneeTypeEnum b : AssigneeTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

