/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details of a user, group, field, or project role that holds a permission. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.")
public class PermissionHolder {
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="parameter")
    private String parameter;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="value")
    private String value;

    @ApiModelProperty(value="Expand options that include additional permission holder details in the response.")
    public String getExpand() {
        return this.expand;
    }

    public PermissionHolder parameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    @ApiModelProperty(value="As a group's name can change, use of `value` is recommended. The identifier associated withthe `type` value that defines the holder of the permission.")
    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public PermissionHolder type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of permission holder.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PermissionHolder value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The identifier associated with the `type` value that defines the holder of the permission.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionHolder permissionHolder = (PermissionHolder)o;
        return Objects.equals(this.expand, permissionHolder.expand) && Objects.equals(this.parameter, permissionHolder.parameter) && Objects.equals(this.type, permissionHolder.type) && Objects.equals(this.value, permissionHolder.value);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.parameter, this.type, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionHolder {\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    parameter: ").append(this.toIndentedString(this.parameter)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

