/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An ordered list of issue type IDs and information about where to move them.")
public class OrderOfIssueTypes {
    @JsonProperty(value="after")
    private String after;
    @JsonProperty(value="issueTypeIds")
    private List<String> issueTypeIds = new ArrayList<String>();
    @JsonProperty(value="position")
    private PositionEnum position;

    public OrderOfIssueTypes after(String after) {
        this.after = after;
        return this;
    }

    @ApiModelProperty(value="The ID of the issue type to place the moved issue types after. Required if `position` isn't provided.")
    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public OrderOfIssueTypes issueTypeIds(List<String> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
        return this;
    }

    public OrderOfIssueTypes addIssueTypeIdsItem(String issueTypeIdsItem) {
        this.issueTypeIds.add(issueTypeIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of the issue type IDs to move. The order of the issue type IDs in the list is the order they are given after the move.")
    public List<String> getIssueTypeIds() {
        return this.issueTypeIds;
    }

    public void setIssueTypeIds(List<String> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
    }

    public OrderOfIssueTypes position(PositionEnum position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(value="The position the issue types should be moved to. Required if `after` isn't provided.")
    public PositionEnum getPosition() {
        return this.position;
    }

    public void setPosition(PositionEnum position) {
        this.position = position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderOfIssueTypes orderOfIssueTypes = (OrderOfIssueTypes)o;
        return Objects.equals(this.after, orderOfIssueTypes.after) && Objects.equals(this.issueTypeIds, orderOfIssueTypes.issueTypeIds) && Objects.equals((Object)this.position, (Object)orderOfIssueTypes.position);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.after, this.issueTypeIds, this.position});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderOfIssueTypes {\n");
        sb.append("    after: ").append(this.toIndentedString(this.after)).append("\n");
        sb.append("    issueTypeIds: ").append(this.toIndentedString(this.issueTypeIds)).append("\n");
        sb.append("    position: ").append(this.toIndentedString((Object)this.position)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PositionEnum {
        FIRST("First"),
        LAST("Last");

        private String value;

        private PositionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PositionEnum fromValue(String value) {
            for (PositionEnum b : PositionEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

