/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.NotificationSchemeEvent;
import org.everit.atlassian.restclient.jiracloud.v2.model.Scope;

@ApiModel(description="Details about a notification scheme.")
public class NotificationScheme {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="notificationSchemeEvents")
    private List<NotificationSchemeEvent> notificationSchemeEvents = new ArrayList<NotificationSchemeEvent>();
    @JsonProperty(value="projects")
    private List<Long> projects = new ArrayList<Long>();
    @JsonProperty(value="scope")
    private Scope scope;
    @JsonProperty(value="self")
    private String self;

    public NotificationScheme description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the notification scheme.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NotificationScheme expand(String expand) {
        this.expand = expand;
        return this;
    }

    @ApiModelProperty(value="Expand options that include additional notification scheme details in the response.")
    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public NotificationScheme id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the notification scheme.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public NotificationScheme name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the notification scheme.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NotificationScheme notificationSchemeEvents(List<NotificationSchemeEvent> notificationSchemeEvents) {
        this.notificationSchemeEvents = notificationSchemeEvents;
        return this;
    }

    public NotificationScheme addNotificationSchemeEventsItem(NotificationSchemeEvent notificationSchemeEventsItem) {
        if (this.notificationSchemeEvents == null) {
            this.notificationSchemeEvents = new ArrayList<NotificationSchemeEvent>();
        }
        this.notificationSchemeEvents.add(notificationSchemeEventsItem);
        return this;
    }

    @ApiModelProperty(value="The notification events and associated recipients.")
    public List<NotificationSchemeEvent> getNotificationSchemeEvents() {
        return this.notificationSchemeEvents;
    }

    public void setNotificationSchemeEvents(List<NotificationSchemeEvent> notificationSchemeEvents) {
        this.notificationSchemeEvents = notificationSchemeEvents;
    }

    public NotificationScheme projects(List<Long> projects) {
        this.projects = projects;
        return this;
    }

    public NotificationScheme addProjectsItem(Long projectsItem) {
        if (this.projects == null) {
            this.projects = new ArrayList<Long>();
        }
        this.projects.add(projectsItem);
        return this;
    }

    @ApiModelProperty(value="The list of project IDs associated with the notification scheme.")
    public List<Long> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Long> projects) {
        this.projects = projects;
    }

    public NotificationScheme scope(Scope scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(value="The scope of the notification scheme.")
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public NotificationScheme self(String self) {
        this.self = self;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationScheme notificationScheme = (NotificationScheme)o;
        return Objects.equals(this.description, notificationScheme.description) && Objects.equals(this.expand, notificationScheme.expand) && Objects.equals(this.id, notificationScheme.id) && Objects.equals(this.name, notificationScheme.name) && Objects.equals(this.notificationSchemeEvents, notificationScheme.notificationSchemeEvents) && Objects.equals(this.projects, notificationScheme.projects) && Objects.equals(this.scope, notificationScheme.scope) && Objects.equals(this.self, notificationScheme.self);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.expand, this.id, this.name, this.notificationSchemeEvents, this.projects, this.scope, this.self);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationScheme {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    notificationSchemeEvents: ").append(this.toIndentedString(this.notificationSchemeEvents)).append("\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

