/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A custom field and its new value with a list of issue to update.")
public class MultipleCustomFieldValuesUpdate {
    @JsonProperty(value="customField")
    private String customField;
    @JsonProperty(value="issueIds")
    private List<Long> issueIds = new ArrayList<Long>();
    @JsonProperty(value="value")
    private Object value = null;

    public MultipleCustomFieldValuesUpdate customField(String customField) {
        this.customField = customField;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID or key of the custom field. For example, `customfield_10010`.")
    public String getCustomField() {
        return this.customField;
    }

    public void setCustomField(String customField) {
        this.customField = customField;
    }

    public MultipleCustomFieldValuesUpdate issueIds(List<Long> issueIds) {
        this.issueIds = issueIds;
        return this;
    }

    public MultipleCustomFieldValuesUpdate addIssueIdsItem(Long issueIdsItem) {
        this.issueIds.add(issueIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of issue IDs.")
    public List<Long> getIssueIds() {
        return this.issueIds;
    }

    public void setIssueIds(List<Long> issueIds) {
        this.issueIds = issueIds;
    }

    public MultipleCustomFieldValuesUpdate value(Object value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="The value for the custom field. The value must be compatible with the [custom field type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#data-types) as follows:   *  `string` the value must be a string.  *  `number` the value must be a number.  *  `datetime` the value must be a string that represents a date in the ISO format or the simplified extended ISO format. For example, `\"2023-01-18T12:00:00-03:00\"` or `\"2023-01-18T12:00:00.000Z\"`. However, the milliseconds part is ignored.  *  `user` the value must be an object that contains the `accountId` field.  *  `group` the value must be an object that contains the group `name` or `groupId` field. Because group names can change, we recommend using `groupId`.  A list of appropriate values must be provided if the field is of the `list` [collection type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#collection-types).")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleCustomFieldValuesUpdate multipleCustomFieldValuesUpdate = (MultipleCustomFieldValuesUpdate)o;
        return Objects.equals(this.customField, multipleCustomFieldValuesUpdate.customField) && Objects.equals(this.issueIds, multipleCustomFieldValuesUpdate.issueIds) && Objects.equals(this.value, multipleCustomFieldValuesUpdate.value);
    }

    public int hashCode() {
        return Objects.hash(this.customField, this.issueIds, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultipleCustomFieldValuesUpdate {\n");
        sb.append("    customField: ").append(this.toIndentedString(this.customField)).append("\n");
        sb.append("    issueIds: ").append(this.toIndentedString(this.issueIds)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

