/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowAssociationStatusMapping;

@ApiModel(description="The status mappings by workflows. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.")
public class MappingsByWorkflow {
    @JsonProperty(value="newWorkflowId")
    private String newWorkflowId;
    @JsonProperty(value="oldWorkflowId")
    private String oldWorkflowId;
    @JsonProperty(value="statusMappings")
    private List<WorkflowAssociationStatusMapping> statusMappings = new ArrayList<WorkflowAssociationStatusMapping>();

    public MappingsByWorkflow newWorkflowId(String newWorkflowId) {
        this.newWorkflowId = newWorkflowId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the new workflow.")
    public String getNewWorkflowId() {
        return this.newWorkflowId;
    }

    public void setNewWorkflowId(String newWorkflowId) {
        this.newWorkflowId = newWorkflowId;
    }

    public MappingsByWorkflow oldWorkflowId(String oldWorkflowId) {
        this.oldWorkflowId = oldWorkflowId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the old workflow.")
    public String getOldWorkflowId() {
        return this.oldWorkflowId;
    }

    public void setOldWorkflowId(String oldWorkflowId) {
        this.oldWorkflowId = oldWorkflowId;
    }

    public MappingsByWorkflow statusMappings(List<WorkflowAssociationStatusMapping> statusMappings) {
        this.statusMappings = statusMappings;
        return this;
    }

    public MappingsByWorkflow addStatusMappingsItem(WorkflowAssociationStatusMapping statusMappingsItem) {
        this.statusMappings.add(statusMappingsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of status mappings.")
    public List<WorkflowAssociationStatusMapping> getStatusMappings() {
        return this.statusMappings;
    }

    public void setStatusMappings(List<WorkflowAssociationStatusMapping> statusMappings) {
        this.statusMappings = statusMappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingsByWorkflow mappingsByWorkflow = (MappingsByWorkflow)o;
        return Objects.equals(this.newWorkflowId, mappingsByWorkflow.newWorkflowId) && Objects.equals(this.oldWorkflowId, mappingsByWorkflow.oldWorkflowId) && Objects.equals(this.statusMappings, mappingsByWorkflow.statusMappings);
    }

    public int hashCode() {
        return Objects.hash(this.newWorkflowId, this.oldWorkflowId, this.statusMappings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MappingsByWorkflow {\n");
        sb.append("    newWorkflowId: ").append(this.toIndentedString(this.newWorkflowId)).append("\n");
        sb.append("    oldWorkflowId: ").append(this.toIndentedString(this.oldWorkflowId)).append("\n");
        sb.append("    statusMappings: ").append(this.toIndentedString(this.statusMappings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

