/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowAssociationStatusMapping;

@ApiModel(description="Overrides, for the selected issue types, any status mappings provided in `statusMappingsByWorkflows`. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.")
public class MappingsByIssueTypeOverride {
    @JsonProperty(value="issueTypeId")
    private String issueTypeId;
    @JsonProperty(value="statusMappings")
    private List<WorkflowAssociationStatusMapping> statusMappings = new ArrayList<WorkflowAssociationStatusMapping>();

    public MappingsByIssueTypeOverride issueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the issue type for this mapping.")
    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public MappingsByIssueTypeOverride statusMappings(List<WorkflowAssociationStatusMapping> statusMappings) {
        this.statusMappings = statusMappings;
        return this;
    }

    public MappingsByIssueTypeOverride addStatusMappingsItem(WorkflowAssociationStatusMapping statusMappingsItem) {
        this.statusMappings.add(statusMappingsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of status mappings.")
    public List<WorkflowAssociationStatusMapping> getStatusMappings() {
        return this.statusMappings;
    }

    public void setStatusMappings(List<WorkflowAssociationStatusMapping> statusMappings) {
        this.statusMappings = statusMappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingsByIssueTypeOverride mappingsByIssueTypeOverride = (MappingsByIssueTypeOverride)o;
        return Objects.equals(this.issueTypeId, mappingsByIssueTypeOverride.issueTypeId) && Objects.equals(this.statusMappings, mappingsByIssueTypeOverride.statusMappings);
    }

    public int hashCode() {
        return Objects.hash(this.issueTypeId, this.statusMappings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MappingsByIssueTypeOverride {\n");
        sb.append("    issueTypeId: ").append(this.toIndentedString(this.issueTypeId)).append("\n");
        sb.append("    statusMappings: ").append(this.toIndentedString(this.statusMappings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

