/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.JqlQueryUnitaryOperand;

@ApiModel(description="An operand that is a list of values.")
public class ListOperand {
    @JsonProperty(value="encodedOperand")
    private String encodedOperand;
    @JsonProperty(value="values")
    private List<JqlQueryUnitaryOperand> values = new ArrayList<JqlQueryUnitaryOperand>();

    public ListOperand encodedOperand(String encodedOperand) {
        this.encodedOperand = encodedOperand;
        return this;
    }

    @ApiModelProperty(value="Encoded operand, which can be used directly in a JQL query.")
    public String getEncodedOperand() {
        return this.encodedOperand;
    }

    public void setEncodedOperand(String encodedOperand) {
        this.encodedOperand = encodedOperand;
    }

    public ListOperand values(List<JqlQueryUnitaryOperand> values) {
        this.values = values;
        return this;
    }

    public ListOperand addValuesItem(JqlQueryUnitaryOperand valuesItem) {
        this.values.add(valuesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of operand values.")
    public List<JqlQueryUnitaryOperand> getValues() {
        return this.values;
    }

    public void setValues(List<JqlQueryUnitaryOperand> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListOperand listOperand = (ListOperand)o;
        return Objects.equals(this.encodedOperand, listOperand.encodedOperand) && Objects.equals(this.values, listOperand.values);
    }

    public int hashCode() {
        return Objects.hash(this.encodedOperand, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListOperand {\n");
        sb.append("    encodedOperand: ").append(this.toIndentedString(this.encodedOperand)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

