/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details about a licensed Jira application.")
public class LicensedApplication {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="plan")
    private PlanEnum plan;

    @ApiModelProperty(required=true, value="The ID of the application.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(required=true, value="The licensing plan.")
    public PlanEnum getPlan() {
        return this.plan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicensedApplication licensedApplication = (LicensedApplication)o;
        return Objects.equals(this.id, licensedApplication.id) && Objects.equals((Object)this.plan, (Object)licensedApplication.plan);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.plan});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LicensedApplication {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    plan: ").append(this.toIndentedString((Object)this.plan)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PlanEnum {
        UNLICENSED("UNLICENSED"),
        FREE("FREE"),
        PAID("PAID");

        private String value;

        private PlanEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PlanEnum fromValue(String value) {
            for (PlanEnum b : PlanEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

