/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.DocumentVersion;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectIssueTypes;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowLayout;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowReferenceStatus;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowScope;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowTransitions;

@ApiModel(description="Details of a workflow.")
public class JiraWorkflow {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="isEditable")
    private Boolean isEditable;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="scope")
    private WorkflowScope scope;
    @JsonProperty(value="startPointLayout")
    private WorkflowLayout startPointLayout;
    @JsonProperty(value="statuses")
    private List<WorkflowReferenceStatus> statuses = new ArrayList<WorkflowReferenceStatus>();
    @JsonProperty(value="taskId")
    private String taskId;
    @JsonProperty(value="transitions")
    private List<WorkflowTransitions> transitions = new ArrayList<WorkflowTransitions>();
    @JsonProperty(value="usages")
    private List<ProjectIssueTypes> usages = new ArrayList<ProjectIssueTypes>();
    @JsonProperty(value="version")
    private DocumentVersion version;

    public JiraWorkflow description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the workflow.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JiraWorkflow id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the workflow.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JiraWorkflow isEditable(Boolean isEditable) {
        this.isEditable = isEditable;
        return this;
    }

    @ApiModelProperty(value="Indicates if the workflow can be edited.")
    public Boolean getIsEditable() {
        return this.isEditable;
    }

    public void setIsEditable(Boolean isEditable) {
        this.isEditable = isEditable;
    }

    public JiraWorkflow name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the workflow.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JiraWorkflow scope(WorkflowScope scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowScope getScope() {
        return this.scope;
    }

    public void setScope(WorkflowScope scope) {
        this.scope = scope;
    }

    public JiraWorkflow startPointLayout(WorkflowLayout startPointLayout) {
        this.startPointLayout = startPointLayout;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowLayout getStartPointLayout() {
        return this.startPointLayout;
    }

    public void setStartPointLayout(WorkflowLayout startPointLayout) {
        this.startPointLayout = startPointLayout;
    }

    public JiraWorkflow statuses(List<WorkflowReferenceStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public JiraWorkflow addStatusesItem(WorkflowReferenceStatus statusesItem) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<WorkflowReferenceStatus>();
        }
        this.statuses.add(statusesItem);
        return this;
    }

    @ApiModelProperty(value="The statuses referenced in this workflow.")
    public List<WorkflowReferenceStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<WorkflowReferenceStatus> statuses) {
        this.statuses = statuses;
    }

    public JiraWorkflow taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @ApiModelProperty(value="If there is a current [asynchronous task](#async-operations) operation for this workflow.")
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public JiraWorkflow transitions(List<WorkflowTransitions> transitions) {
        this.transitions = transitions;
        return this;
    }

    public JiraWorkflow addTransitionsItem(WorkflowTransitions transitionsItem) {
        if (this.transitions == null) {
            this.transitions = new ArrayList<WorkflowTransitions>();
        }
        this.transitions.add(transitionsItem);
        return this;
    }

    @ApiModelProperty(value="The transitions of the workflow.")
    public List<WorkflowTransitions> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(List<WorkflowTransitions> transitions) {
        this.transitions = transitions;
    }

    public JiraWorkflow usages(List<ProjectIssueTypes> usages) {
        this.usages = usages;
        return this;
    }

    public JiraWorkflow addUsagesItem(ProjectIssueTypes usagesItem) {
        if (this.usages == null) {
            this.usages = new ArrayList<ProjectIssueTypes>();
        }
        this.usages.add(usagesItem);
        return this;
    }

    @ApiModelProperty(value="Use the optional `workflows.usages` expand to get additional information about the projects and issue types associated with the requested workflows.")
    public List<ProjectIssueTypes> getUsages() {
        return this.usages;
    }

    public void setUsages(List<ProjectIssueTypes> usages) {
        this.usages = usages;
    }

    public JiraWorkflow version(DocumentVersion version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="")
    public DocumentVersion getVersion() {
        return this.version;
    }

    public void setVersion(DocumentVersion version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraWorkflow jiraWorkflow = (JiraWorkflow)o;
        return Objects.equals(this.description, jiraWorkflow.description) && Objects.equals(this.id, jiraWorkflow.id) && Objects.equals(this.isEditable, jiraWorkflow.isEditable) && Objects.equals(this.name, jiraWorkflow.name) && Objects.equals(this.scope, jiraWorkflow.scope) && Objects.equals(this.startPointLayout, jiraWorkflow.startPointLayout) && Objects.equals(this.statuses, jiraWorkflow.statuses) && Objects.equals(this.taskId, jiraWorkflow.taskId) && Objects.equals(this.transitions, jiraWorkflow.transitions) && Objects.equals(this.usages, jiraWorkflow.usages) && Objects.equals(this.version, jiraWorkflow.version);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.id, this.isEditable, this.name, this.scope, this.startPointLayout, this.statuses, this.taskId, this.transitions, this.usages, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JiraWorkflow {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isEditable: ").append(this.toIndentedString(this.isEditable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    startPointLayout: ").append(this.toIndentedString(this.startPointLayout)).append("\n");
        sb.append("    statuses: ").append(this.toIndentedString(this.statuses)).append("\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    transitions: ").append(this.toIndentedString(this.transitions)).append("\n");
        sb.append("    usages: ").append(this.toIndentedString(this.usages)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

