/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectIssueTypes;
import org.everit.atlassian.restclient.jiracloud.v2.model.StatusScope;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowUsages;

@ApiModel(description="Details of a status.")
public class JiraStatus {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="scope")
    private StatusScope scope;
    @JsonProperty(value="statusCategory")
    private StatusCategoryEnum statusCategory;
    @JsonProperty(value="usages")
    private List<ProjectIssueTypes> usages = new ArrayList<ProjectIssueTypes>();
    @JsonProperty(value="workflowUsages")
    private List<WorkflowUsages> workflowUsages = new ArrayList<WorkflowUsages>();

    public JiraStatus description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the status.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JiraStatus id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the status.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JiraStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the status.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JiraStatus scope(StatusScope scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(value="")
    public StatusScope getScope() {
        return this.scope;
    }

    public void setScope(StatusScope scope) {
        this.scope = scope;
    }

    public JiraStatus statusCategory(StatusCategoryEnum statusCategory) {
        this.statusCategory = statusCategory;
        return this;
    }

    @ApiModelProperty(value="The category of the status.")
    public StatusCategoryEnum getStatusCategory() {
        return this.statusCategory;
    }

    public void setStatusCategory(StatusCategoryEnum statusCategory) {
        this.statusCategory = statusCategory;
    }

    public JiraStatus usages(List<ProjectIssueTypes> usages) {
        this.usages = usages;
        return this;
    }

    public JiraStatus addUsagesItem(ProjectIssueTypes usagesItem) {
        if (this.usages == null) {
            this.usages = new ArrayList<ProjectIssueTypes>();
        }
        this.usages.add(usagesItem);
        return this;
    }

    @ApiModelProperty(value="Projects and issue types where the status is used. Only available if the `usages` expand is requested.")
    public List<ProjectIssueTypes> getUsages() {
        return this.usages;
    }

    public void setUsages(List<ProjectIssueTypes> usages) {
        this.usages = usages;
    }

    public JiraStatus workflowUsages(List<WorkflowUsages> workflowUsages) {
        this.workflowUsages = workflowUsages;
        return this;
    }

    public JiraStatus addWorkflowUsagesItem(WorkflowUsages workflowUsagesItem) {
        if (this.workflowUsages == null) {
            this.workflowUsages = new ArrayList<WorkflowUsages>();
        }
        this.workflowUsages.add(workflowUsagesItem);
        return this;
    }

    @ApiModelProperty(value="The workflows that use this status. Only available if the `workflowUsages` expand is requested.")
    public List<WorkflowUsages> getWorkflowUsages() {
        return this.workflowUsages;
    }

    public void setWorkflowUsages(List<WorkflowUsages> workflowUsages) {
        this.workflowUsages = workflowUsages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraStatus jiraStatus = (JiraStatus)o;
        return Objects.equals(this.description, jiraStatus.description) && Objects.equals(this.id, jiraStatus.id) && Objects.equals(this.name, jiraStatus.name) && Objects.equals(this.scope, jiraStatus.scope) && Objects.equals((Object)this.statusCategory, (Object)jiraStatus.statusCategory) && Objects.equals(this.usages, jiraStatus.usages) && Objects.equals(this.workflowUsages, jiraStatus.workflowUsages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.id, this.name, this.scope, this.statusCategory, this.usages, this.workflowUsages});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JiraStatus {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    statusCategory: ").append(this.toIndentedString((Object)this.statusCategory)).append("\n");
        sb.append("    usages: ").append(this.toIndentedString(this.usages)).append("\n");
        sb.append("    workflowUsages: ").append(this.toIndentedString(this.workflowUsages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusCategoryEnum {
        TODO("TODO"),
        IN_PROGRESS("IN_PROGRESS"),
        DONE("DONE");

        private String value;

        private StatusCategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusCategoryEnum fromValue(String value) {
            for (StatusCategoryEnum b : StatusCategoryEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

