/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details about syntax and type errors. The error details apply to the entire expression, unless the object includes:   *  `line` and `column`  *  `expression`")
public class JiraExpressionValidationError {
    @JsonProperty(value="column")
    private Integer column;
    @JsonProperty(value="expression")
    private String expression;
    @JsonProperty(value="line")
    private Integer line;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="type")
    private TypeEnum type;

    public JiraExpressionValidationError column(Integer column) {
        this.column = column;
        return this;
    }

    @ApiModelProperty(value="The text column in which the error occurred.")
    public Integer getColumn() {
        return this.column;
    }

    public void setColumn(Integer column) {
        this.column = column;
    }

    public JiraExpressionValidationError expression(String expression) {
        this.expression = expression;
        return this;
    }

    @ApiModelProperty(value="The part of the expression in which the error occurred.")
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public JiraExpressionValidationError line(Integer line) {
        this.line = line;
        return this;
    }

    @ApiModelProperty(value="The text line in which the error occurred.")
    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public JiraExpressionValidationError message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(example="!, -, typeof, (, IDENTIFIER, null, true, false, NUMBER, STRING, TEMPLATE_LITERAL, new, [ or { expected, > encountered.", required=true, value="Details about the error.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public JiraExpressionValidationError type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The error type.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraExpressionValidationError jiraExpressionValidationError = (JiraExpressionValidationError)o;
        return Objects.equals(this.column, jiraExpressionValidationError.column) && Objects.equals(this.expression, jiraExpressionValidationError.expression) && Objects.equals(this.line, jiraExpressionValidationError.line) && Objects.equals(this.message, jiraExpressionValidationError.message) && Objects.equals((Object)this.type, (Object)jiraExpressionValidationError.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.expression, this.line, this.message, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JiraExpressionValidationError {\n");
        sb.append("    column: ").append(this.toIndentedString(this.column)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    line: ").append(this.toIndentedString(this.line)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        SYNTAX("syntax"),
        TYPE("type"),
        OTHER("other");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

