/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.CustomContextVariable;
import org.everit.atlassian.restclient.jiracloud.v2.model.IdOrKeyBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.JexpIssues;

public class JiraExpressionEvalContextBean {
    @JsonProperty(value="board")
    private Long board;
    @JsonProperty(value="custom")
    private List<CustomContextVariable> custom = new ArrayList<CustomContextVariable>();
    @JsonProperty(value="customerRequest")
    private Long customerRequest;
    @JsonProperty(value="issue")
    private IdOrKeyBean issue;
    @JsonProperty(value="issues")
    private JexpIssues issues;
    @JsonProperty(value="project")
    private IdOrKeyBean project;
    @JsonProperty(value="serviceDesk")
    private Long serviceDesk;
    @JsonProperty(value="sprint")
    private Long sprint;

    public JiraExpressionEvalContextBean board(Long board) {
        this.board = board;
        return this;
    }

    @ApiModelProperty(value="The ID of the board that is available under the `board` variable when evaluating the expression.")
    public Long getBoard() {
        return this.board;
    }

    public void setBoard(Long board) {
        this.board = board;
    }

    public JiraExpressionEvalContextBean custom(List<CustomContextVariable> custom) {
        this.custom = custom;
        return this;
    }

    public JiraExpressionEvalContextBean addCustomItem(CustomContextVariable customItem) {
        if (this.custom == null) {
            this.custom = new ArrayList<CustomContextVariable>();
        }
        this.custom.add(customItem);
        return this;
    }

    @ApiModelProperty(value="Custom context variables and their types. These variable types are available for use in a custom context:   *  `user`: A [user](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user) specified as an Atlassian account ID.  *  `issue`: An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.  *  `json`: A JSON object containing custom content.  *  `list`: A JSON list of `user`, `issue`, or `json` variable types.")
    public List<CustomContextVariable> getCustom() {
        return this.custom;
    }

    public void setCustom(List<CustomContextVariable> custom) {
        this.custom = custom;
    }

    public JiraExpressionEvalContextBean customerRequest(Long customerRequest) {
        this.customerRequest = customerRequest;
        return this;
    }

    @ApiModelProperty(value="The ID of the customer request that is available under the `customerRequest` variable when evaluating the expression. This is the same as the ID of the underlying Jira issue, but the customer request context variable will have a different type.")
    public Long getCustomerRequest() {
        return this.customerRequest;
    }

    public void setCustomerRequest(Long customerRequest) {
        this.customerRequest = customerRequest;
    }

    public JiraExpressionEvalContextBean issue(IdOrKeyBean issue) {
        this.issue = issue;
        return this;
    }

    @ApiModelProperty(value="The issue that is available under the `issue` variable when evaluating the expression.")
    public IdOrKeyBean getIssue() {
        return this.issue;
    }

    public void setIssue(IdOrKeyBean issue) {
        this.issue = issue;
    }

    public JiraExpressionEvalContextBean issues(JexpIssues issues) {
        this.issues = issues;
        return this;
    }

    @ApiModelProperty(value="The collection of issues that is available under the `issues` variable when evaluating the expression.")
    public JexpIssues getIssues() {
        return this.issues;
    }

    public void setIssues(JexpIssues issues) {
        this.issues = issues;
    }

    public JiraExpressionEvalContextBean project(IdOrKeyBean project) {
        this.project = project;
        return this;
    }

    @ApiModelProperty(value="The project that is available under the `project` variable when evaluating the expression.")
    public IdOrKeyBean getProject() {
        return this.project;
    }

    public void setProject(IdOrKeyBean project) {
        this.project = project;
    }

    public JiraExpressionEvalContextBean serviceDesk(Long serviceDesk) {
        this.serviceDesk = serviceDesk;
        return this;
    }

    @ApiModelProperty(value="The ID of the service desk that is available under the `serviceDesk` variable when evaluating the expression.")
    public Long getServiceDesk() {
        return this.serviceDesk;
    }

    public void setServiceDesk(Long serviceDesk) {
        this.serviceDesk = serviceDesk;
    }

    public JiraExpressionEvalContextBean sprint(Long sprint) {
        this.sprint = sprint;
        return this;
    }

    @ApiModelProperty(value="The ID of the sprint that is available under the `sprint` variable when evaluating the expression.")
    public Long getSprint() {
        return this.sprint;
    }

    public void setSprint(Long sprint) {
        this.sprint = sprint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraExpressionEvalContextBean jiraExpressionEvalContextBean = (JiraExpressionEvalContextBean)o;
        return Objects.equals(this.board, jiraExpressionEvalContextBean.board) && Objects.equals(this.custom, jiraExpressionEvalContextBean.custom) && Objects.equals(this.customerRequest, jiraExpressionEvalContextBean.customerRequest) && Objects.equals(this.issue, jiraExpressionEvalContextBean.issue) && Objects.equals(this.issues, jiraExpressionEvalContextBean.issues) && Objects.equals(this.project, jiraExpressionEvalContextBean.project) && Objects.equals(this.serviceDesk, jiraExpressionEvalContextBean.serviceDesk) && Objects.equals(this.sprint, jiraExpressionEvalContextBean.sprint);
    }

    public int hashCode() {
        return Objects.hash(this.board, this.custom, this.customerRequest, this.issue, this.issues, this.project, this.serviceDesk, this.sprint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JiraExpressionEvalContextBean {\n");
        sb.append("    board: ").append(this.toIndentedString(this.board)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("    customerRequest: ").append(this.toIndentedString(this.customerRequest)).append("\n");
        sb.append("    issue: ").append(this.toIndentedString(this.issue)).append("\n");
        sb.append("    issues: ").append(this.toIndentedString(this.issues)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    serviceDesk: ").append(this.toIndentedString(this.serviceDesk)).append("\n");
        sb.append("    sprint: ").append(this.toIndentedString(this.sprint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

