/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.StatusDetails;

@ApiModel(description="Status details for an issue type.")
public class IssueTypeWithStatus {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="self")
    private String self;
    @JsonProperty(value="statuses")
    private List<StatusDetails> statuses = new ArrayList<StatusDetails>();
    @JsonProperty(value="subtask")
    private Boolean subtask;

    @ApiModelProperty(required=true, value="The ID of the issue type.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(required=true, value="The name of the issue type.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(required=true, value="The URL of the issue type's status details.")
    public String getSelf() {
        return this.self;
    }

    @ApiModelProperty(required=true, value="List of status details for the issue type.")
    public List<StatusDetails> getStatuses() {
        return this.statuses;
    }

    @ApiModelProperty(required=true, value="Whether this issue type represents subtasks.")
    public Boolean getSubtask() {
        return this.subtask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTypeWithStatus issueTypeWithStatus = (IssueTypeWithStatus)o;
        return Objects.equals(this.id, issueTypeWithStatus.id) && Objects.equals(this.name, issueTypeWithStatus.name) && Objects.equals(this.self, issueTypeWithStatus.self) && Objects.equals(this.statuses, issueTypeWithStatus.statuses) && Objects.equals(this.subtask, issueTypeWithStatus.subtask);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.self, this.statuses, this.subtask);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueTypeWithStatus {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    statuses: ").append(this.toIndentedString(this.statuses)).append("\n");
        sb.append("    subtask: ").append(this.toIndentedString(this.subtask)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

