/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class IssueTypeCreateBean {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="hierarchyLevel")
    private Integer hierarchyLevel;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private TypeEnum type;

    public IssueTypeCreateBean description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the issue type.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IssueTypeCreateBean hierarchyLevel(Integer hierarchyLevel) {
        this.hierarchyLevel = hierarchyLevel;
        return this;
    }

    @ApiModelProperty(value="The hierarchy level of the issue type. Use:   *  `-1` for Subtask.  *  `0` for Base.  Defaults to `0`.")
    public Integer getHierarchyLevel() {
        return this.hierarchyLevel;
    }

    public void setHierarchyLevel(Integer hierarchyLevel) {
        this.hierarchyLevel = hierarchyLevel;
    }

    public IssueTypeCreateBean name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique name for the issue type. The maximum length is 60 characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IssueTypeCreateBean type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Deprecated. Use `hierarchyLevel` instead. See the [deprecation notice](https://community.developer.atlassian.com/t/deprecation-of-the-epic-link-parent-link-and-other-related-fields-in-rest-apis-and-webhooks/54048) for details.  Whether the issue type is `subtype` or `standard`. Defaults to `standard`.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTypeCreateBean issueTypeCreateBean = (IssueTypeCreateBean)o;
        return Objects.equals(this.description, issueTypeCreateBean.description) && Objects.equals(this.hierarchyLevel, issueTypeCreateBean.hierarchyLevel) && Objects.equals(this.name, issueTypeCreateBean.name) && Objects.equals((Object)this.type, (Object)issueTypeCreateBean.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.hierarchyLevel, this.name, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueTypeCreateBean {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    hierarchyLevel: ").append(this.toIndentedString(this.hierarchyLevel)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        SUBTASK("subtask"),
        STANDARD("standard");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

