/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;

@ApiModel(description="This object is used as follows:   *  In the [ issueLink](#api-rest-api-2-issueLink-post) resource it defines and reports on the type of link between the issues. Find a list of issue link types with [Get issue link types](#api-rest-api-2-issueLinkType-get).  *  In the [ issueLinkType](#api-rest-api-2-issueLinkType-post) resource it defines and reports on issue link types.")
public class IssueLinkType {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="inward")
    private String inward;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="outward")
    private String outward;
    @JsonProperty(value="self")
    private URI self;

    public IssueLinkType id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the issue link type and is used as follows:   *  In the [ issueLink](#api-rest-api-2-issueLink-post) resource it is the type of issue link. Required on create when `name` isn't provided. Otherwise, read only.  *  In the [ issueLinkType](#api-rest-api-2-issueLinkType-post) resource it is read only.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IssueLinkType inward(String inward) {
        this.inward = inward;
        return this;
    }

    @ApiModelProperty(value="The description of the issue link type inward link and is used as follows:   *  In the [ issueLink](#api-rest-api-2-issueLink-post) resource it is read only.  *  In the [ issueLinkType](#api-rest-api-2-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.")
    public String getInward() {
        return this.inward;
    }

    public void setInward(String inward) {
        this.inward = inward;
    }

    public IssueLinkType name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the issue link type and is used as follows:   *  In the [ issueLink](#api-rest-api-2-issueLink-post) resource it is the type of issue link. Required on create when `id` isn't provided. Otherwise, read only.  *  In the [ issueLinkType](#api-rest-api-2-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IssueLinkType outward(String outward) {
        this.outward = outward;
        return this;
    }

    @ApiModelProperty(value="The description of the issue link type outward link and is used as follows:   *  In the [ issueLink](#api-rest-api-2-issueLink-post) resource it is read only.  *  In the [ issueLinkType](#api-rest-api-2-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.")
    public String getOutward() {
        return this.outward;
    }

    public void setOutward(String outward) {
        this.outward = outward;
    }

    @ApiModelProperty(value="The URL of the issue link type. Read only.")
    public URI getSelf() {
        return this.self;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueLinkType issueLinkType = (IssueLinkType)o;
        return Objects.equals(this.id, issueLinkType.id) && Objects.equals(this.inward, issueLinkType.inward) && Objects.equals(this.name, issueLinkType.name) && Objects.equals(this.outward, issueLinkType.outward) && Objects.equals(this.self, issueLinkType.self);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.inward, this.name, this.outward, this.self);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueLinkType {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    inward: ").append(this.toIndentedString(this.inward)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    outward: ").append(this.toIndentedString(this.outward)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

