/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.")
public class IssueContextVariable {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="type")
    private String type;

    public IssueContextVariable id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The issue ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public IssueContextVariable key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="The issue key.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public IssueContextVariable type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of custom context variable.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueContextVariable issueContextVariable = (IssueContextVariable)o;
        return Objects.equals(this.id, issueContextVariable.id) && Objects.equals(this.key, issueContextVariable.key) && Objects.equals(this.type, issueContextVariable.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueContextVariable {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

