/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="An icon. If no icon is defined:   *  for a status icon, no status icon displays in Jira.  *  for the remote object icon, the default link icon displays in Jira.")
public class Icon {
    @JsonProperty(value="link")
    private String link;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="url16x16")
    private String url16x16;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public Icon link(String link) {
        this.link = link;
        return this;
    }

    @ApiModelProperty(value="The URL of the tooltip, used only for a status icon. If not set, the status icon in Jira is not clickable.")
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Icon title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="The title of the icon. This is used as follows:   *  For a status icon it is used as a tooltip on the icon. If not set, the status icon doesn't display a tooltip in Jira.  *  For the remote object icon it is used in conjunction with the application name to display a tooltip for the link's icon. The tooltip takes the format \"\\[application name\\] icon title\". Blank itemsare excluded from the tooltip title. If both items are blank, the icon tooltop displays as \"Web Link\".")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Icon url16x16(String url16x16) {
        this.url16x16 = url16x16;
        return this;
    }

    @ApiModelProperty(value="The URL of an icon that displays at 16x16 pixel in Jira.")
    public String getUrl16x16() {
        return this.url16x16;
    }

    public void setUrl16x16(String url16x16) {
        this.url16x16 = url16x16;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Icon icon = (Icon)o;
        return Objects.equals(this.link, icon.link) && Objects.equals(this.title, icon.title) && Objects.equals(this.url16x16, icon.url16x16) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.link, this.title, this.url16x16, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Icon {\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    url16x16: ").append(this.toIndentedString(this.url16x16)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

