/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.HistoryMetadataParticipant;

@ApiModel(description="Details of issue history metadata.")
public class HistoryMetadata {
    @JsonProperty(value="activityDescription")
    private String activityDescription;
    @JsonProperty(value="activityDescriptionKey")
    private String activityDescriptionKey;
    @JsonProperty(value="actor")
    private HistoryMetadataParticipant actor;
    @JsonProperty(value="cause")
    private HistoryMetadataParticipant cause;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="descriptionKey")
    private String descriptionKey;
    @JsonProperty(value="emailDescription")
    private String emailDescription;
    @JsonProperty(value="emailDescriptionKey")
    private String emailDescriptionKey;
    @JsonProperty(value="extraData")
    private Map<String, String> extraData = new HashMap<String, String>();
    @JsonProperty(value="generator")
    private HistoryMetadataParticipant generator;
    @JsonProperty(value="type")
    private String type;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public HistoryMetadata activityDescription(String activityDescription) {
        this.activityDescription = activityDescription;
        return this;
    }

    @ApiModelProperty(value="The activity described in the history record.")
    public String getActivityDescription() {
        return this.activityDescription;
    }

    public void setActivityDescription(String activityDescription) {
        this.activityDescription = activityDescription;
    }

    public HistoryMetadata activityDescriptionKey(String activityDescriptionKey) {
        this.activityDescriptionKey = activityDescriptionKey;
        return this;
    }

    @ApiModelProperty(value="The key of the activity described in the history record.")
    public String getActivityDescriptionKey() {
        return this.activityDescriptionKey;
    }

    public void setActivityDescriptionKey(String activityDescriptionKey) {
        this.activityDescriptionKey = activityDescriptionKey;
    }

    public HistoryMetadata actor(HistoryMetadataParticipant actor) {
        this.actor = actor;
        return this;
    }

    @ApiModelProperty(value="Details of the user whose action created the history record.")
    public HistoryMetadataParticipant getActor() {
        return this.actor;
    }

    public void setActor(HistoryMetadataParticipant actor) {
        this.actor = actor;
    }

    public HistoryMetadata cause(HistoryMetadataParticipant cause) {
        this.cause = cause;
        return this;
    }

    @ApiModelProperty(value="Details of the cause that triggered the creation the history record.")
    public HistoryMetadataParticipant getCause() {
        return this.cause;
    }

    public void setCause(HistoryMetadataParticipant cause) {
        this.cause = cause;
    }

    public HistoryMetadata description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the history record.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public HistoryMetadata descriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
        return this;
    }

    @ApiModelProperty(value="The description key of the history record.")
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    public HistoryMetadata emailDescription(String emailDescription) {
        this.emailDescription = emailDescription;
        return this;
    }

    @ApiModelProperty(value="The description of the email address associated the history record.")
    public String getEmailDescription() {
        return this.emailDescription;
    }

    public void setEmailDescription(String emailDescription) {
        this.emailDescription = emailDescription;
    }

    public HistoryMetadata emailDescriptionKey(String emailDescriptionKey) {
        this.emailDescriptionKey = emailDescriptionKey;
        return this;
    }

    @ApiModelProperty(value="The description key of the email address associated the history record.")
    public String getEmailDescriptionKey() {
        return this.emailDescriptionKey;
    }

    public void setEmailDescriptionKey(String emailDescriptionKey) {
        this.emailDescriptionKey = emailDescriptionKey;
    }

    public HistoryMetadata extraData(Map<String, String> extraData) {
        this.extraData = extraData;
        return this;
    }

    public HistoryMetadata putExtraDataItem(String key, String extraDataItem) {
        if (this.extraData == null) {
            this.extraData = new HashMap<String, String>();
        }
        this.extraData.put(key, extraDataItem);
        return this;
    }

    @ApiModelProperty(value="Additional arbitrary information about the history record.")
    public Map<String, String> getExtraData() {
        return this.extraData;
    }

    public void setExtraData(Map<String, String> extraData) {
        this.extraData = extraData;
    }

    public HistoryMetadata generator(HistoryMetadataParticipant generator) {
        this.generator = generator;
        return this;
    }

    @ApiModelProperty(value="Details of the system that generated the history record.")
    public HistoryMetadataParticipant getGenerator() {
        return this.generator;
    }

    public void setGenerator(HistoryMetadataParticipant generator) {
        this.generator = generator;
    }

    public HistoryMetadata type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the history record.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryMetadata historyMetadata = (HistoryMetadata)o;
        return Objects.equals(this.activityDescription, historyMetadata.activityDescription) && Objects.equals(this.activityDescriptionKey, historyMetadata.activityDescriptionKey) && Objects.equals(this.actor, historyMetadata.actor) && Objects.equals(this.cause, historyMetadata.cause) && Objects.equals(this.description, historyMetadata.description) && Objects.equals(this.descriptionKey, historyMetadata.descriptionKey) && Objects.equals(this.emailDescription, historyMetadata.emailDescription) && Objects.equals(this.emailDescriptionKey, historyMetadata.emailDescriptionKey) && Objects.equals(this.extraData, historyMetadata.extraData) && Objects.equals(this.generator, historyMetadata.generator) && Objects.equals(this.type, historyMetadata.type) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.activityDescription, this.activityDescriptionKey, this.actor, this.cause, this.description, this.descriptionKey, this.emailDescription, this.emailDescriptionKey, this.extraData, this.generator, this.type, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoryMetadata {\n");
        sb.append("    activityDescription: ").append(this.toIndentedString(this.activityDescription)).append("\n");
        sb.append("    activityDescriptionKey: ").append(this.toIndentedString(this.activityDescriptionKey)).append("\n");
        sb.append("    actor: ").append(this.toIndentedString(this.actor)).append("\n");
        sb.append("    cause: ").append(this.toIndentedString(this.cause)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    descriptionKey: ").append(this.toIndentedString(this.descriptionKey)).append("\n");
        sb.append("    emailDescription: ").append(this.toIndentedString(this.emailDescription)).append("\n");
        sb.append("    emailDescriptionKey: ").append(this.toIndentedString(this.emailDescriptionKey)).append("\n");
        sb.append("    extraData: ").append(this.toIndentedString(this.extraData)).append("\n");
        sb.append("    generator: ").append(this.toIndentedString(this.generator)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

