/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class HierarchyLevel {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="aboveLevelId")
    private Long aboveLevelId;
    @JsonProperty(value="belowLevelId")
    private Long belowLevelId;
    @JsonProperty(value="projectConfigurationId")
    private Long projectConfigurationId;
    @JsonProperty(value="level")
    private Integer level;
    @JsonProperty(value="issueTypeIds")
    private List<Long> issueTypeIds = new ArrayList<Long>();
    @JsonProperty(value="externalUuid")
    private UUID externalUuid;
    @JsonProperty(value="globalHierarchyLevel")
    private GlobalHierarchyLevelEnum globalHierarchyLevel;

    public HierarchyLevel id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public HierarchyLevel name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of this hierarchy level.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HierarchyLevel aboveLevelId(Long aboveLevelId) {
        this.aboveLevelId = aboveLevelId;
        return this;
    }

    @ApiModelProperty(value="The ID of the level above this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
    public Long getAboveLevelId() {
        return this.aboveLevelId;
    }

    public void setAboveLevelId(Long aboveLevelId) {
        this.aboveLevelId = aboveLevelId;
    }

    public HierarchyLevel belowLevelId(Long belowLevelId) {
        this.belowLevelId = belowLevelId;
        return this;
    }

    @ApiModelProperty(value="The ID of the level below this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
    public Long getBelowLevelId() {
        return this.belowLevelId;
    }

    public void setBelowLevelId(Long belowLevelId) {
        this.belowLevelId = belowLevelId;
    }

    public HierarchyLevel projectConfigurationId(Long projectConfigurationId) {
        this.projectConfigurationId = projectConfigurationId;
        return this;
    }

    @ApiModelProperty(value="The ID of the project configuration. This property is deprecated, see [Change oticen: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
    public Long getProjectConfigurationId() {
        return this.projectConfigurationId;
    }

    public void setProjectConfigurationId(Long projectConfigurationId) {
        this.projectConfigurationId = projectConfigurationId;
    }

    public HierarchyLevel level(Integer level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(value="The level of this item in the hierarchy.")
    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public HierarchyLevel issueTypeIds(List<Long> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
        return this;
    }

    public HierarchyLevel addIssueTypeIdsItem(Long issueTypeIdsItem) {
        if (this.issueTypeIds == null) {
            this.issueTypeIds = new ArrayList<Long>();
        }
        this.issueTypeIds.add(issueTypeIdsItem);
        return this;
    }

    @ApiModelProperty(value="The issue types available in this hierarchy level.")
    public List<Long> getIssueTypeIds() {
        return this.issueTypeIds;
    }

    public void setIssueTypeIds(List<Long> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
    }

    public HierarchyLevel externalUuid(UUID externalUuid) {
        this.externalUuid = externalUuid;
        return this;
    }

    @ApiModelProperty(value="The external UUID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
    public UUID getExternalUuid() {
        return this.externalUuid;
    }

    public void setExternalUuid(UUID externalUuid) {
        this.externalUuid = externalUuid;
    }

    public HierarchyLevel globalHierarchyLevel(GlobalHierarchyLevelEnum globalHierarchyLevel) {
        this.globalHierarchyLevel = globalHierarchyLevel;
        return this;
    }

    @ApiModelProperty(value="")
    public GlobalHierarchyLevelEnum getGlobalHierarchyLevel() {
        return this.globalHierarchyLevel;
    }

    public void setGlobalHierarchyLevel(GlobalHierarchyLevelEnum globalHierarchyLevel) {
        this.globalHierarchyLevel = globalHierarchyLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HierarchyLevel hierarchyLevel = (HierarchyLevel)o;
        return Objects.equals(this.id, hierarchyLevel.id) && Objects.equals(this.name, hierarchyLevel.name) && Objects.equals(this.aboveLevelId, hierarchyLevel.aboveLevelId) && Objects.equals(this.belowLevelId, hierarchyLevel.belowLevelId) && Objects.equals(this.projectConfigurationId, hierarchyLevel.projectConfigurationId) && Objects.equals(this.level, hierarchyLevel.level) && Objects.equals(this.issueTypeIds, hierarchyLevel.issueTypeIds) && Objects.equals(this.externalUuid, hierarchyLevel.externalUuid) && Objects.equals((Object)this.globalHierarchyLevel, (Object)hierarchyLevel.globalHierarchyLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.aboveLevelId, this.belowLevelId, this.projectConfigurationId, this.level, this.issueTypeIds, this.externalUuid, this.globalHierarchyLevel});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HierarchyLevel {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    aboveLevelId: ").append(this.toIndentedString(this.aboveLevelId)).append("\n");
        sb.append("    belowLevelId: ").append(this.toIndentedString(this.belowLevelId)).append("\n");
        sb.append("    projectConfigurationId: ").append(this.toIndentedString(this.projectConfigurationId)).append("\n");
        sb.append("    level: ").append(this.toIndentedString(this.level)).append("\n");
        sb.append("    issueTypeIds: ").append(this.toIndentedString(this.issueTypeIds)).append("\n");
        sb.append("    externalUuid: ").append(this.toIndentedString(this.externalUuid)).append("\n");
        sb.append("    globalHierarchyLevel: ").append(this.toIndentedString((Object)this.globalHierarchyLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GlobalHierarchyLevelEnum {
        SUBTASK("SUBTASK"),
        BASE("BASE"),
        EPIC("EPIC");

        private String value;

        private GlobalHierarchyLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GlobalHierarchyLevelEnum fromValue(String value) {
            for (GlobalHierarchyLevelEnum b : GlobalHierarchyLevelEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

