/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.SimplifiedHierarchyLevel;

@ApiModel(description="The project issue type hierarchy.")
public class Hierarchy {
    @JsonProperty(value="baseLevelId")
    private Long baseLevelId;
    @JsonProperty(value="levels")
    private List<SimplifiedHierarchyLevel> levels = new ArrayList<SimplifiedHierarchyLevel>();

    public Hierarchy baseLevelId(Long baseLevelId) {
        this.baseLevelId = baseLevelId;
        return this;
    }

    @ApiModelProperty(value="The ID of the base level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
    public Long getBaseLevelId() {
        return this.baseLevelId;
    }

    public void setBaseLevelId(Long baseLevelId) {
        this.baseLevelId = baseLevelId;
    }

    @ApiModelProperty(value="Details about the hierarchy level.")
    public List<SimplifiedHierarchyLevel> getLevels() {
        return this.levels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hierarchy hierarchy = (Hierarchy)o;
        return Objects.equals(this.baseLevelId, hierarchy.baseLevelId) && Objects.equals(this.levels, hierarchy.levels);
    }

    public int hashCode() {
        return Objects.hash(this.baseLevelId, this.levels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Hierarchy {\n");
        sb.append("    baseLevelId: ").append(this.toIndentedString(this.baseLevelId)).append("\n");
        sb.append("    levels: ").append(this.toIndentedString(this.levels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

