/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.GroupName;
import org.everit.atlassian.restclient.jiracloud.v2.model.User;

@ApiModel(description="Details of a user or group subscribing to a filter.")
public class FilterSubscription {
    @JsonProperty(value="group")
    private GroupName group;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="user")
    private User user;

    @ApiModelProperty(value="The group subscribing to filter.")
    public GroupName getGroup() {
        return this.group;
    }

    @ApiModelProperty(value="The ID of the filter subscription.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The user subscribing to filter.")
    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterSubscription filterSubscription = (FilterSubscription)o;
        return Objects.equals(this.group, filterSubscription.group) && Objects.equals(this.id, filterSubscription.id) && Objects.equals(this.user, filterSubscription.user);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.id, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilterSubscription {\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

