/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.FilterSubscriptionsList;
import org.everit.atlassian.restclient.jiracloud.v2.model.SharePermission;
import org.everit.atlassian.restclient.jiracloud.v2.model.User;
import org.everit.atlassian.restclient.jiracloud.v2.model.UserList;

@ApiModel(description="Details about a filter.")
public class Filter {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="editPermissions")
    private List<SharePermission> editPermissions = new ArrayList<SharePermission>();
    @JsonProperty(value="favourite")
    private Boolean favourite;
    @JsonProperty(value="favouritedCount")
    private Long favouritedCount;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="jql")
    private String jql;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="owner")
    private User owner;
    @JsonProperty(value="searchUrl")
    private URI searchUrl;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="sharePermissions")
    private List<SharePermission> sharePermissions = new ArrayList<SharePermission>();
    @JsonProperty(value="sharedUsers")
    private UserList sharedUsers;
    @JsonProperty(value="subscriptions")
    private FilterSubscriptionsList subscriptions;
    @JsonProperty(value="viewUrl")
    private URI viewUrl;

    public Filter description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the filter.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Filter editPermissions(List<SharePermission> editPermissions) {
        this.editPermissions = editPermissions;
        return this;
    }

    public Filter addEditPermissionsItem(SharePermission editPermissionsItem) {
        if (this.editPermissions == null) {
            this.editPermissions = new ArrayList<SharePermission>();
        }
        this.editPermissions.add(editPermissionsItem);
        return this;
    }

    @ApiModelProperty(value="The groups and projects that can edit the filter.")
    public List<SharePermission> getEditPermissions() {
        return this.editPermissions;
    }

    public void setEditPermissions(List<SharePermission> editPermissions) {
        this.editPermissions = editPermissions;
    }

    public Filter favourite(Boolean favourite) {
        this.favourite = favourite;
        return this;
    }

    @ApiModelProperty(value="Whether the filter is selected as a favorite.")
    public Boolean getFavourite() {
        return this.favourite;
    }

    public void setFavourite(Boolean favourite) {
        this.favourite = favourite;
    }

    @ApiModelProperty(value="The count of how many users have selected this filter as a favorite, including the filter owner.")
    public Long getFavouritedCount() {
        return this.favouritedCount;
    }

    @ApiModelProperty(value="The unique identifier for the filter.")
    public String getId() {
        return this.id;
    }

    public Filter jql(String jql) {
        this.jql = jql;
        return this;
    }

    @ApiModelProperty(value="The JQL query for the filter. For example, *project = SSP AND issuetype = Bug*.")
    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public Filter name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the filter. Must be unique.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The user who owns the filter. This is defaulted to the creator of the filter, however Jira administrators can change the owner of a shared filter in the admin settings.")
    public User getOwner() {
        return this.owner;
    }

    @ApiModelProperty(value="A URL to view the filter results in Jira, using the [Search for issues using JQL](#api-rest-api-2-filter-search-get) operation with the filter's JQL string to return the filter results. For example, *https://your-domain.atlassian.net/rest/api/2/search?jql=project+%3D+SSP+AND+issuetype+%3D+Bug*.")
    public URI getSearchUrl() {
        return this.searchUrl;
    }

    @ApiModelProperty(value="The URL of the filter.")
    public URI getSelf() {
        return this.self;
    }

    public Filter sharePermissions(List<SharePermission> sharePermissions) {
        this.sharePermissions = sharePermissions;
        return this;
    }

    public Filter addSharePermissionsItem(SharePermission sharePermissionsItem) {
        if (this.sharePermissions == null) {
            this.sharePermissions = new ArrayList<SharePermission>();
        }
        this.sharePermissions.add(sharePermissionsItem);
        return this;
    }

    @ApiModelProperty(value="The groups and projects that the filter is shared with.")
    public List<SharePermission> getSharePermissions() {
        return this.sharePermissions;
    }

    public void setSharePermissions(List<SharePermission> sharePermissions) {
        this.sharePermissions = sharePermissions;
    }

    @ApiModelProperty(value="A paginated list of the users that the filter is shared with. This includes users that are members of the groups or can browse the projects that the filter is shared with.")
    public UserList getSharedUsers() {
        return this.sharedUsers;
    }

    @ApiModelProperty(value="A paginated list of the users that are subscribed to the filter.")
    public FilterSubscriptionsList getSubscriptions() {
        return this.subscriptions;
    }

    @ApiModelProperty(value="A URL to view the filter results in Jira, using the ID of the filter. For example, *https://your-domain.atlassian.net/issues/?filter=10100*.")
    public URI getViewUrl() {
        return this.viewUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filter filter = (Filter)o;
        return Objects.equals(this.description, filter.description) && Objects.equals(this.editPermissions, filter.editPermissions) && Objects.equals(this.favourite, filter.favourite) && Objects.equals(this.favouritedCount, filter.favouritedCount) && Objects.equals(this.id, filter.id) && Objects.equals(this.jql, filter.jql) && Objects.equals(this.name, filter.name) && Objects.equals(this.owner, filter.owner) && Objects.equals(this.searchUrl, filter.searchUrl) && Objects.equals(this.self, filter.self) && Objects.equals(this.sharePermissions, filter.sharePermissions) && Objects.equals(this.sharedUsers, filter.sharedUsers) && Objects.equals(this.subscriptions, filter.subscriptions) && Objects.equals(this.viewUrl, filter.viewUrl);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.editPermissions, this.favourite, this.favouritedCount, this.id, this.jql, this.name, this.owner, this.searchUrl, this.self, this.sharePermissions, this.sharedUsers, this.subscriptions, this.viewUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Filter {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    editPermissions: ").append(this.toIndentedString(this.editPermissions)).append("\n");
        sb.append("    favourite: ").append(this.toIndentedString(this.favourite)).append("\n");
        sb.append("    favouritedCount: ").append(this.toIndentedString(this.favouritedCount)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    jql: ").append(this.toIndentedString(this.jql)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    searchUrl: ").append(this.toIndentedString(this.searchUrl)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    sharePermissions: ").append(this.toIndentedString(this.sharePermissions)).append("\n");
        sb.append("    sharedUsers: ").append(this.toIndentedString(this.sharedUsers)).append("\n");
        sb.append("    subscriptions: ").append(this.toIndentedString(this.subscriptions)).append("\n");
        sb.append("    viewUrl: ").append(this.toIndentedString(this.viewUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

