/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="Information about the most recent use of a field.")
public class FieldLastUsed {
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="value")
    private OffsetDateTime value;

    public FieldLastUsed type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Last used value type:   *  *TRACKED*: field is tracked and a last used date is available.  *  *NOT\\_TRACKED*: field is not tracked, last used date is not available.  *  *NO\\_INFORMATION*: field is tracked, but no last used date is available.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FieldLastUsed value(OffsetDateTime value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The date when the value of the field last changed.")
    public OffsetDateTime getValue() {
        return this.value;
    }

    public void setValue(OffsetDateTime value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldLastUsed fieldLastUsed = (FieldLastUsed)o;
        return Objects.equals((Object)this.type, (Object)fieldLastUsed.type) && Objects.equals(this.value, fieldLastUsed.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldLastUsed {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        TRACKED("TRACKED"),
        NOT_TRACKED("NOT_TRACKED"),
        NO_INFORMATION("NO_INFORMATION");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

