/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.FieldLastUsed;
import org.everit.atlassian.restclient.jiracloud.v2.model.JsonTypeBean;

@ApiModel(description="Details of a field.")
public class Field {
    @JsonProperty(value="contextsCount")
    private Long contextsCount;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="isLocked")
    private Boolean isLocked;
    @JsonProperty(value="isUnscreenable")
    private Boolean isUnscreenable;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="lastUsed")
    private FieldLastUsed lastUsed;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="projectsCount")
    private Long projectsCount;
    @JsonProperty(value="schema")
    private JsonTypeBean schema;
    @JsonProperty(value="screensCount")
    private Long screensCount;
    @JsonProperty(value="searcherKey")
    private String searcherKey;

    public Field contextsCount(Long contextsCount) {
        this.contextsCount = contextsCount;
        return this;
    }

    @ApiModelProperty(value="Number of contexts where the field is used.")
    public Long getContextsCount() {
        return this.contextsCount;
    }

    public void setContextsCount(Long contextsCount) {
        this.contextsCount = contextsCount;
    }

    public Field description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the field.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Field id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the field.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Field isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @ApiModelProperty(value="Whether the field is locked.")
    public Boolean getIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public Field isUnscreenable(Boolean isUnscreenable) {
        this.isUnscreenable = isUnscreenable;
        return this;
    }

    @ApiModelProperty(value="Whether the field is shown on screen or not.")
    public Boolean getIsUnscreenable() {
        return this.isUnscreenable;
    }

    public void setIsUnscreenable(Boolean isUnscreenable) {
        this.isUnscreenable = isUnscreenable;
    }

    public Field key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="The key of the field.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Field lastUsed(FieldLastUsed lastUsed) {
        this.lastUsed = lastUsed;
        return this;
    }

    @ApiModelProperty(value="")
    public FieldLastUsed getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(FieldLastUsed lastUsed) {
        this.lastUsed = lastUsed;
    }

    public Field name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the field.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Field projectsCount(Long projectsCount) {
        this.projectsCount = projectsCount;
        return this;
    }

    @ApiModelProperty(value="Number of projects where the field is used.")
    public Long getProjectsCount() {
        return this.projectsCount;
    }

    public void setProjectsCount(Long projectsCount) {
        this.projectsCount = projectsCount;
    }

    public Field schema(JsonTypeBean schema) {
        this.schema = schema;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JsonTypeBean getSchema() {
        return this.schema;
    }

    public void setSchema(JsonTypeBean schema) {
        this.schema = schema;
    }

    public Field screensCount(Long screensCount) {
        this.screensCount = screensCount;
        return this;
    }

    @ApiModelProperty(value="Number of screens where the field is used.")
    public Long getScreensCount() {
        return this.screensCount;
    }

    public void setScreensCount(Long screensCount) {
        this.screensCount = screensCount;
    }

    public Field searcherKey(String searcherKey) {
        this.searcherKey = searcherKey;
        return this;
    }

    @ApiModelProperty(value="The searcher key of the field. Returned for custom fields.")
    public String getSearcherKey() {
        return this.searcherKey;
    }

    public void setSearcherKey(String searcherKey) {
        this.searcherKey = searcherKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return Objects.equals(this.contextsCount, field.contextsCount) && Objects.equals(this.description, field.description) && Objects.equals(this.id, field.id) && Objects.equals(this.isLocked, field.isLocked) && Objects.equals(this.isUnscreenable, field.isUnscreenable) && Objects.equals(this.key, field.key) && Objects.equals(this.lastUsed, field.lastUsed) && Objects.equals(this.name, field.name) && Objects.equals(this.projectsCount, field.projectsCount) && Objects.equals(this.schema, field.schema) && Objects.equals(this.screensCount, field.screensCount) && Objects.equals(this.searcherKey, field.searcherKey);
    }

    public int hashCode() {
        return Objects.hash(this.contextsCount, this.description, this.id, this.isLocked, this.isUnscreenable, this.key, this.lastUsed, this.name, this.projectsCount, this.schema, this.screensCount, this.searcherKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Field {\n");
        sb.append("    contextsCount: ").append(this.toIndentedString(this.contextsCount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    isUnscreenable: ").append(this.toIndentedString(this.isUnscreenable)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    lastUsed: ").append(this.toIndentedString(this.lastUsed)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    projectsCount: ").append(this.toIndentedString(this.projectsCount)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    screensCount: ").append(this.toIndentedString(this.screensCount)).append("\n");
        sb.append("    searcherKey: ").append(this.toIndentedString(this.searcherKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

